package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author ZeHua Li
 * @date 2020/11/25 15:40
 * @since v2.0
 */
@Data
@TableName("wl_video_important_equipment")
@ApiModel(value = "VideoImportantEquipment对象", description = "视频重点设备关联")
public class VideoImportantEquipment {

    @ApiModelProperty(value = "id")
    @TableId(type = IdType.ID_WORKER)
    private Long id;

    @ApiModelProperty(value = "视频id")
    @TableField(value = "video_id")
    private Long videoId;

    @ApiModelProperty(value = "f_equipment表id（重点设备id）")
    @TableField(value = "important_equipment_id")
    private Long importantEquipmentId;

    @TableField(exist = false)
    private Date createDate;
}
