package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author ZeHua Li
 * @date 2020/11/23 15:34
 * @since v2.0
 */
@Data
@TableName("wl_video_source")
@ApiModel(value = "VideoSource对象", description = "视频区域关联")
public class VideoSource {

    @ApiModelProperty(value = "id")
    @TableId(type = IdType.ID_WORKER)
    private Long id;

    @ApiModelProperty(value = "视频id")
    @TableField(value = "video_id")
    private Long videoId;

    @ApiModelProperty(value = "区域id")
    @TableField(value = "source_id")
    private Long sourceId;

    @TableField(exist = false)
    private Date createDate;

    @ApiModelProperty(value = "本级及父级建筑ids，冗余树形搜索")
    private String parentSourceIds;
}
