package com.yeejoin.amos.boot.module.jcs.api.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author DELL
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("cb_organization")
@ApiModel(value="Organization对象", description="组织机构应急小组")
public class Organization extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "应急小组名称")
    private String emergencyTeamName;

    @ApiModelProperty(value = "所属单位名称")
    private String bizOrgName;

    @ApiModelProperty(value = "所属单位code")
    private String bizOrgCode;

    @ApiModelProperty(value = "组长")
    private String groupLeader;

    @ApiModelProperty(value = "组长电话")
    private String groupLeaderTel;

    @ApiModelProperty(value = "副组长")
    private String deputyGroupLeader;

    @ApiModelProperty(value = "副组长电话")
    private String deputyGroupLeaderTel;

    @ApiModelProperty(value = "职责")
    private String duty;

    @ApiModelProperty(value = "照片地址")
    private String photoUrls;

    @ApiModelProperty(value = "附件")
    private String enclosure;

    @ApiModelProperty(value = "组长id")
    private String groupLeaderId;

    @ApiModelProperty(value = "副组长id")
    private String deputyGroupLeaderId;

    @ApiModelProperty(value = "父id")
    private Long parentId;

    @ApiModelProperty(value = "排序")
    private int sort;
}
