package com.yeejoin.amos.latentdanger.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */
public enum MsgTypeEnum {
	/**
	 * 隐患排查
	 */
    CHECK("隐患排查", "check");

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    private MsgTypeEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public static MsgTypeEnum getEnum(String code) {
        MsgTypeEnum MsgTypeEnum = null;
        for (MsgTypeEnum type : MsgTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                MsgTypeEnum = type;
                break;
            }
        }

        return MsgTypeEnum;
    }

    public static List<Map<String, String>> getEnumList() {
        List<Map<String, String>> list = new ArrayList<>();
        for (MsgTypeEnum e : MsgTypeEnum.values()) {
            Map<String, String> msgType = new HashMap<>();
            msgType.put(e.getCode(), e.getName());
            list.add(msgType);
        }
        return list;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
