package com.yeejoin.amos.latentdanger.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 计划类型枚举（机场单位、外部单位）
 */
public enum PlanTypeEnum {
	OUTER("外部单位检查","1", "outer"),
	INNER("机场单位检查","0", "inner");

	/**
	 * 名称，描述
	 */
	private String name;

	/**
	 * 编码
	 */
	private String code;

	private String value;

	PlanTypeEnum(String name, String code, String value){
		this.name = name;
		this.code = code;
		this.value = value;
	}
	
	public static PlanTypeEnum getEnum(String code) {
		PlanTypeEnum auditEnum = null;
		for(PlanTypeEnum type: PlanTypeEnum.values()) {
			if (type.getCode().equals(code)) {
				auditEnum = type;
				break;
			}
		}
		
		return auditEnum;
	}
	
	public static List<Map<String,String>> getEnumList() {
		List<Map<String,String>> nameList = new ArrayList<>();
		for (PlanTypeEnum c: PlanTypeEnum.values()) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("name", c.getName());
			map.put("code", c.getCode());
			nameList.add(map);
		}
		return nameList;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}
}
