package com.yeejoin.amos.maintenance.common.enums;

import java.util.*;
import java.util.stream.Collectors;

public enum PlanTaskDetailIsFinishEnum {
	UNFINISHED("未完成",0),
	FINISHED("已完成",1),
	OVERTIME("超时未维保",2);
	
	/**
	 * 名称
	 */
	private String name;

	/**
	 * 值
	 */
	private int value;
	


	private PlanTaskDetailIsFinishEnum(String name, int value) {
		this.name = name;
		this.value = value;
	}

	public static List<Map<String, Object>> getEnumList() {
		return Arrays.stream(PlanTaskDetailIsFinishEnum.values()).map(e -> {
			Map<String, Object> map = new HashMap<>();
			map.put(String.valueOf(e.getValue()), e.getName());
			return map;
		}).collect(Collectors.toList());
	}


	public static String getName(int value) {
		for (PlanTaskDetailIsFinishEnum c : PlanTaskDetailIsFinishEnum.values()) {
			if (c.getValue() == value) {
				return c.name;
			}
		}
		return null;
	}
	
	public static int getValue(String name) {
		for (PlanTaskDetailIsFinishEnum c : PlanTaskDetailIsFinishEnum.values()) {
			if (c.getName().equals(name)) {
				return c.value;
			}
		}
		return -1;
	}


	public static PlanTaskDetailIsFinishEnum getEnum(int value) {
		for (PlanTaskDetailIsFinishEnum c : PlanTaskDetailIsFinishEnum.values()) {
			if (c.getValue() == value) {
				return c;
			}
		}
		return null;
	}


	public static PlanTaskDetailIsFinishEnum getEnum(String name) {
		for (PlanTaskDetailIsFinishEnum c : PlanTaskDetailIsFinishEnum.values()) {
			if (c.getName().equals(name)) {
				return c;
			}
		}
		return null;
	}
	
	public static List<String> getEnumNameList() {
		List<String> nameList = new ArrayList<String>();
		for (PlanTaskDetailIsFinishEnum c: PlanTaskDetailIsFinishEnum.values()) {
			nameList.add(c.getName());
		}
		return nameList;
	}

	public String getName() {
		return name;
	}


	public void setName(String name) {
		this.name = name;
	}


	public int getValue() {
		return value;
	}


	public void setValue(int value) {
		this.value = value;
	}
}
