package com.yeejoin.precontrol.common.component;

import com.yeejoin.precontrol.common.entity.hk.model.po.MediaConfig;
import com.yeejoin.precontrol.common.entity.hk.model.po.MediaHkApiConfig;
import com.yeejoin.precontrol.common.service.hk.IMediaConfigService;
import com.yeejoin.precontrol.common.service.hk.IMediaHkApiConfigService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: songLei
 * @Description: 初始化资源配置
 * @Date: 2021/4/29 10:42
 * @Version: 1.0
 */
@Slf4j
@Component
@AllArgsConstructor
public class InitContext {
    public static Map<String, String> memoryDataMap = new HashMap<>();
    @Autowired
    private IMediaConfigService mediaConfigService;
    @Autowired
    private IMediaHkApiConfigService mediaHkApiConfigService;
    @PostConstruct
    private void init() {
        log.info("正在初始化数据......");
        this.initMediaConfig();
        this.initMediaHkApiConfig();
        log.info("初始化数据完成");
    }
    /**
     * @Author songLei
     * @Version  1.0
     * @Description 初始化流媒体服务配置数据
     * @Date 2021/4/29 11:23
     */
    private void initMediaConfig(){
        List<MediaConfig> mediaConfigs = mediaConfigService.findAll();
        if(CollectionUtils.isNotEmpty(mediaConfigs)){
            mediaConfigs.stream().forEach(item ->{
                memoryDataMap.put(item.getConfigKey(),item.getConfigValue());
            });
        }
    }
    /**
     * @Author songLei
     * @Version  1.0
     * @Description 初始化海康平台接口配置数据
     * @Date 2021/4/29 11:23
     */
    private void initMediaHkApiConfig(){
        List<MediaHkApiConfig> mediaHkApiConfigs = mediaHkApiConfigService.findAll();
        if(CollectionUtils.isNotEmpty(mediaHkApiConfigs)){
            mediaHkApiConfigs.stream().forEach(item ->{
                log.info("key:{},api:{}",item.getApiKey(),item.getApiUrl());
                memoryDataMap.put(item.getApiKey(),item.getApiUrl());
            });
        }
    }
}
