package com.yeejoin.precontrol.common.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 危险作业表Dto
 *
 * @author duanwei
 * @date 2020-08-24
 */
@Data
@ApiModel(value = "HazardousWork对象", description = "危险作业表")
public class HazardousWorkDto  {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty(value = "危险作业名称")
    private String name;

    @ApiModelProperty(value = "作业条件_输入项")
    private String conditions;

    @ApiModelProperty(value = "描述")
    private String remark;

    @ApiModelProperty(value = "编号")
    private String orderNo;

    @ApiModelProperty(value = "检查措施")
    private List<InputItemDto> inputItemDtos;

    private Date createDate;
}
