package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 工商信息附件
 *
 * @author sqy
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_company_business_attachment")
@ApiModel(value = "CompanyBusinessAttachment对象", description = "企业工商附件")
public class CompanyBusinessAttachment extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "企业工商id")
    private Long companyBusinessId;
    @ApiModelProperty(value = "附件地址")
    @ImagePrefix
    private String attachment;
}
