package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 人员基本信息
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("rpm_person")
@ApiModel(value = "Person对象", description = "人员基本信息")
public class Person extends BaseEntity {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "姓名")
	private String name;

	@ApiModelProperty(value = "性别( 0-男 1-女 )")
	private Long sex;
	@TableField(exist = false)
	private String sexLabel;//

	@ApiModelProperty(value = "生日")
	private Date birthday;
	@ApiModelProperty(value = "年龄")
	private Long age;
	@ApiModelProperty(value = "名族")
	private String folkKey;
	@ApiModelProperty(value = "身高")
	private Long height;
	@ApiModelProperty(value = "体重")
	private Long weight;
	@ApiModelProperty(value = "电话")
	private String phone;
	@ApiModelProperty(value = "应急电话")
	private String emergencyPhone;
	@ApiModelProperty(value = "政治面貌")
	private String politicCountenance;
	@ApiModelProperty(value = "证件编号")
	@TableField("ID_number")
	private String idNumber;
	@ApiModelProperty(value = "证件类型")

	@TableField("ID_type")
	private Long idType;
	@TableField(exist = false)
	private String idTypeLabel;

	@ApiModelProperty(value = "籍贯")
	private String nativePlace;
	@TableField(exist = false)
	private String nativePlaceLabel;

	@ApiModelProperty(value = "用工来源所在地")
	private String employPlace;
	@TableField(exist = false)
	private String employPlaceLabel;

	@ApiModelProperty(value = "地址")
	private String address;
	@ApiModelProperty(value = "现住址")
	private String presentAddress;
	@ApiModelProperty(value = "参加工作时间")
	private Date workTime;
	@ApiModelProperty(value = "头像照片")
	@ImagePrefix
	private String headPhoto;
	@ApiModelProperty(value = "证件照片正面")
	@ImagePrefix
	private String frontCertificatePhoto;
	@ApiModelProperty(value = "证件照片反面")
	@ImagePrefix
	private String backCertificatePhoto;
	@ApiModelProperty(value = "考核成绩")
	private Long examineScore;
	@ApiModelProperty(value = "是否合格")
	private Boolean qualified;
	@ApiModelProperty(value = "综合评分")
	private Float compositeScore;
	@ApiModelProperty(value = "是否可用")
	private Long isEnabled;
	@ApiModelProperty(value = "平台账号id")
	private Long userId;
	@ApiModelProperty(value = "平台账号名称")
	private String accountName;
	@ApiModelProperty(value = "二维码颜色0红 1黄 2绿")
	private Long color;
	@ApiModelProperty(value = "用户角色")
	private String roles;
	@ApiModelProperty(value = "用户角色名称")
	private String roleName;
	@ApiModelProperty(value = "红码次数")
	private Integer redCount;
	@ApiModelProperty(value = "黑名单")
	private Long isBlack;
	@ApiModelProperty(value = "机构ID")
	private String orgCode;
	@ApiModelProperty(value = "激活状态，用于出入场")
	private Long activeStatus;
	@ApiModelProperty(value = "是否是江西电建")
	private Long isJxdj;
	@ApiModelProperty(value = "工号")
	private String jobNumber;
	@ApiModelProperty(value = "部门类型")
	private String deptType;
	@ApiModelProperty(value = "用户角色key")
	private String roleKey;
	@ApiModelProperty(value = "合格阶段")
	private Integer qualifiedStage;
	@ApiModelProperty(value = "审核状态：,1-待审核，2-审核拒绝，3-审核通过")
	private Integer verifyStatus;
	@ApiModelProperty(value = "openId")
	private String openId;
}
