package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;
/**
 * 奖励惩罚配置表
 *
 * @author duanwei
 * @date 2021-04-06
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_reward_config")
@ApiModel(value="RewardConfig对象", description="奖励惩罚配置表")
public class RewardConfig extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "项目id")
    private Long projectId;

    @ApiModelProperty(value = "违规类型，关联字典表code")
    private String code;

    @ApiModelProperty(value = "惩罚金额")
    private BigDecimal retributionMoney;

    @ApiModelProperty(value = "奖励金额")
    private BigDecimal rewardMoney;

    @ApiModelProperty(value = "更新时间")
    private Date updateDate;


}
