package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 风险作业管理表
 *
 * @author duanwei
 * @date 2021-01-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_risk_work")
@ApiModel(value = "RiskWork对象", description = "风险作业管理表")
public class RiskWork extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @NotBlank(message = "风险作业名称不能为空")
    @ApiModelProperty(value = "风险作业名称")
    private String name;

    @NotBlank(message = "风险等级不能为空")
    @ApiModelProperty(value = "风险等级")
    private String level;

    @NotBlank(message = "风险等级名称不能为空")
    @ApiModelProperty(value = "名称（冗余字段）")
    private String levelName;

    @ApiModelProperty(value = "创建者")
    private String createId;

    @ApiModelProperty(value = "创建者名称")
    @TableField(exist = false)
    private String createName;

    @TableField(exist = false)
    private List<HazardousWork> hazardousWorks;
    
    private String orgCode;

}
