package com.yeejoin.precontrol.common.enums;

/*
 * 奖励状态
 */
public enum RewardEum {
    /*
     * 未兑换
     */
    NOT_REDEEMED("未兑换", 0),
    /*
     * 已兑换
     */
    REDEEMED("已兑换", 1);

    private String label;
    private Integer value;

    RewardEum(String label, Integer value) {
        this.label = label;
        this.value = value;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public static String getLabelByValue(Integer value) {
        String label = null;
        for (RewardEum type : RewardEum.values()) {
            if (type.getValue().equals(value)) {
                label = type.getLabel();
                break;
            }
        }
        return label;
    }
}
