package com.yeejoin.precontrol.common.service.hk.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.precontrol.common.entity.hk.model.po.MediaHkApiConfig;
import com.yeejoin.precontrol.common.mapper.hk.MediaHkApiConfigMapper;
import com.yeejoin.precontrol.common.service.hk.IMediaHkApiConfigService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;

/**
 * @Author: songLei
 * @Description: 海康视频平台接口配置业务类
 * @Date: 2021/4/29 11:04
 * @Version: 1.0
 */
@Service
public class MediaHkApiConfigServiceImpl extends ServiceImpl<MediaHkApiConfigMapper, MediaHkApiConfig> implements IMediaHkApiConfigService {
    /**
     * @Author songLei
     * @Version 1.0
     * @Description 查询所有海康平台接口配置数据
     * @Date 2021/4/29 11:12
     */
    @Override
    public List<MediaHkApiConfig> findAll() {
        List<MediaHkApiConfig> mediaHkApiConfigs = this.list(new QueryWrapper<MediaHkApiConfig>()
                .lambda()
                .eq(MediaHkApiConfig::getIsDelete, Boolean.FALSE));
        return CollectionUtils.isNotEmpty(mediaHkApiConfigs) ? mediaHkApiConfigs : Collections.emptyList();
    }
}
