package com.yeejoin.precontrol.common.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 今日违章员列表
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
public class BadPersonVo {

    @ApiModelProperty(value = "人员id")
    private Long id;
    @ApiModelProperty(value = "姓名")
    @Excel(name = "姓名")
    private String name;
    @ApiModelProperty(value = "项目名称")
    @Excel(name = "项目名称")
    private String projectName;
    @ApiModelProperty(value = "分包商")
    @Excel(name = "分包商")
    private String companyName;
    @ApiModelProperty(value = "地区")
    @Excel(name = "地区")
    private String regionName;
    @ApiModelProperty(value = "安全态势")
    @Excel(name = "安全态势", replace = {"红码_0", "黄码_1", "绿码_2"})
    private String color;
    @ApiModelProperty(value = "违章类型")
    @Excel(name = "违章类型")
    private String badType;
}
