package com.yeejoin.precontrol.common.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.yeejoin.precontrol.common.entity.ProjectCamera;
import com.yeejoin.precontrol.common.entity.ProjectCompany;
import com.yeejoin.precontrol.common.entity.ProjectCoordinate;
import com.yeejoin.precontrol.common.entity.ProjectDevice;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 项目信息
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
public class ProjectVo {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "主键")
    private Long id;
    @ApiModelProperty(value = "项目名称")
    @Excel(name = "项目名称")
    private String name;
    @ApiModelProperty(value = "手机号码")
    @Excel(name = "手机号码")
    private Long phone;
    @ApiModelProperty(value = "项目经理")
    @Excel(name = "项目经理")
    private String manager;
    @ApiModelProperty(value = "邮箱")
    @Excel(name = "邮箱")
    private String email;
    @ApiModelProperty(value = "建设单位")
    @Excel(name = "建设单位")
    private String company;
    @ApiModelProperty(value = "地区")
    private String region;
    @ApiModelProperty(value = "地区名称")
    @Excel(name = "地区名称")
    private String regionName;
    @ApiModelProperty(value = "经度")
    @Excel(name = "经度")
    private Double longitude;
    @ApiModelProperty(value = "纬度")
    @Excel(name = "纬度")
    private Double latitude;
    @ApiModelProperty(value = "打卡范围（半径）")
    @Excel(name = "打卡范围（半径）")
    private Double clockScope;
    @ApiModelProperty(value = "项目地址")
    @Excel(name = "项目地址")
    private String address;
    @ApiModelProperty(value = "状态")
    @Excel(name = "状态")
    private String status;
    @ApiModelProperty(value = "开始时间")
    @Excel(name = "开始时间", exportFormat = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;
    @ApiModelProperty(value = "项目编号")
    @Excel(name = "项目编号")
    private String projectNum;
    @ApiModelProperty(value = "简介")
    @Excel(name = "简介")
    private String introduction;
    @ApiModelProperty(value = "分包商数量")
    @Excel(name = "分包商数量")
    private Integer companyNum;
    @ApiModelProperty(value = "施工人数")
    @Excel(name = "施工人数")
    private Integer personNum;

    @ApiModelProperty(value = "平台项目部名称")
    @Excel(name = "项目部")
    private String platformProjectName;

    @ApiModelProperty(value = "分包商ID")
    private String companyId;
    @ApiModelProperty(value = "创建时间")
    @Excel(name = "创建时间", exportFormat = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;
    @ApiModelProperty(value = "项目安全态势分")
    private Integer securityScore;
    @ApiModelProperty(value = "未交底人员数量")
    private Long noJobPersonNum;


    @ApiModelProperty(value = "平台项目部ID")
    private Long platformProjectId;

    @ApiModelProperty(value = "机构ID")
    private String orgCode;
    @ApiModelProperty(value = "项目坐标信息")
    private List<ProjectCoordinate> projectCoordinateList;
	@ApiModelProperty(value = "项目分包商")
	private List<ProjectCompany> projectCompanyList;
	@ApiModelProperty(value = "项目设备")
	private List<ProjectDevice> projectDeviceList;
    private List<ProjectCamera> cameraList;
    private String projectRegion;
}
