package com.yeejoin.amos.supervision.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum PlanTaskDetailIsFinishEnum {
	UNFINISHED("未开始",0),
	EXECUTION("执行中",1),
	FINISHED("已完成",2),
	OVERTIME("超时漏检",3);
	
	/**
	 * 名称
	 */
	private String name;

	/**
	 * 值
	 */
	private int value;
	


	private PlanTaskDetailIsFinishEnum(String name, int value) {
		this.name = name;
		this.value = value;
	}


	public static String getName(int value) {
		for (PlanTaskDetailIsFinishEnum c : PlanTaskDetailIsFinishEnum.values()) {
			if (c.getValue() == value) {
				return c.name;
			}
		}
		return null;
	}
	
	public static int getValue(String name) {
		for (PlanTaskDetailIsFinishEnum c : PlanTaskDetailIsFinishEnum.values()) {
			if (c.getName().equals(name)) {
				return c.value;
			}
		}
		return -1;
	}


	public static PlanTaskDetailIsFinishEnum getEnum(int value) {
		for (PlanTaskDetailIsFinishEnum c : PlanTaskDetailIsFinishEnum.values()) {
			if (c.getValue() == value) {
				return c;
			}
		}
		return null;
	}


	public static PlanTaskDetailIsFinishEnum getEnum(String name) {
		for (PlanTaskDetailIsFinishEnum c : PlanTaskDetailIsFinishEnum.values()) {
			if (c.getName().equals(name)) {
				return c;
			}
		}
		return null;
	}

	public static List<Map<String,String>> getEnumList() {
		List<Map<String,String>> nameList = new ArrayList<>();
		for (PlanTaskDetailIsFinishEnum c: PlanTaskDetailIsFinishEnum.values()) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("name", c.getName());
			map.put("value", c.getValue() +"");
			nameList.add(map);
		}
		return nameList;
	}
	
	public static List<String> getEnumNameList() {
		List<String> nameList = new ArrayList<String>();
		for (PlanTaskDetailIsFinishEnum c: PlanTaskDetailIsFinishEnum.values()) {
			nameList.add(c.getName());
		}
		return nameList;
	}

	public String getName() {
		return name;
	}


	public void setName(String name) {
		this.name = name;
	}


	public int getValue() {
		return value;
	}


	public void setValue(int value) {
		this.value = value;
	}
}
