package com.yeejoin.amos.boot.module.common.biz.controller;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.common.biz.service.impl.DynamicFormGroupServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.DynamicFormGroupDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;


/**
* 动态表单分组表(支持树形)
*
* @author system_generator
* @date 2021-07-06
*/
@RestController
@Api(tags = "动态表单分组表(支持树形)Api")
@RequestMapping(value = "/common/dynamic-form-group")
public class DynamicFormGroupController extends BaseController {

    @Autowired
    DynamicFormGroupServiceImpl dynamicFormGroupServiceImpl;

    /**
             * 新增动态表单分组表(支持树形)
    * @return
    */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增动态表单分组表(支持树形)", notes = "新增动态表单分组表(支持树形)")
	public ResponseModel<DynamicFormGroupDto> save(@RequestBody DynamicFormGroupDto model)
	{
	    model=dynamicFormGroupServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}
	/**
             * 根据sequenceNbr更新
    * @param sequenceNbr 主键
    * @return
    */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新动态表单分组表(支持树形)", notes = "根据sequenceNbr更新动态表单分组表(支持树形)")
	public ResponseModel<DynamicFormGroupDto> updateBySequenceNbrDynamicFormGroup(@RequestBody DynamicFormGroupDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(dynamicFormGroupServiceImpl.updateWithModel(model));
	}
	/**
             * 根据sequenceNbr删除
    * @param sequenceNbr 主键
    * @return
    */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除动态表单分组表(支持树形)", notes = "根据sequenceNbr删除动态表单分组表(支持树形)")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(dynamicFormGroupServiceImpl.removeById(sequenceNbr));
    }
    /**
             * 根据sequenceNbr查询
    * @param sequenceNbr  主键
    * @return
    */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个动态表单分组表(支持树形)",  notes = "根据sequenceNbr查询单个动态表单分组表(支持树形)")
	public ResponseModel<DynamicFormGroupDto> seleteOne(@PathVariable Long sequenceNbr)
	{
	    return ResponseHelper.buildResponse(dynamicFormGroupServiceImpl.queryBySeq(sequenceNbr));
	}
	/**
             * 列表分页查询
    *@param current 当前页
    *@param current 每页大小
    * @return
    */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "动态表单分组表(支持树形)分页查询",  notes = "动态表单分组表(支持树形)分页查询")
	public ResponseModel<Page<DynamicFormGroupDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam(value = "size") int size)
	{
	    Page<DynamicFormGroupDto> page=new Page<DynamicFormGroupDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(dynamicFormGroupServiceImpl.queryForDynamicFormGroupPage(page));
	}
	/**
	*列表全部数据查询
	*@return
	*/
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "动态表单分组表(支持树形)列表全部数据查询",   notes = "动态表单分组表(支持树形)列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<DynamicFormGroupDto>>  selectForList()
	{
	    return ResponseHelper.buildResponse(dynamicFormGroupServiceImpl.queryForDynamicFormGroupList());
	}
}
