package com.yeejoin.equipmanage.controller;

import com.yeejoin.equipmanage.common.entity.dto.FormGroupColumnEquipDto;
import com.yeejoin.equipmanage.config.PersonIdentify;
import com.yeejoin.equipmanage.service.IFormInstanceEquipService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.List;
import java.util.Map;


/**
 * 动态表单控制器
 *
 * @author gaojianqiang
 * @date 2022-10-09
 */
@RestController
@Api(tags = "动态表单实例Api")
@RequestMapping(value = "/form-instance", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class FormInstanceController extends AbstractBaseController {


    @Autowired
    private IFormInstanceEquipService formInstanceEquipService;


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "通过分组code查询列及值信息", notes = "通过分组code查询列及值信息")
    @RequestMapping(value = "/queryColumnAndValueByGroup", method = RequestMethod.GET)
    public List<FormGroupColumnEquipDto> queryColumnAndValueByGroup(@RequestParam String groupCode, @RequestParam(required = false) Long instanceId) {
        return formInstanceEquipService.queryColumnAndValueByGroup(groupCode, instanceId);
    }


    @PostMapping(value = "/commonSave")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "通用保存")
    @PersonIdentify
    public Object save(
            @RequestParam(value = "groupCode") String groupCode,
            @RequestParam(value = "instanceId", required = false) String instanceId,
            @RequestBody Map<String, Object> map) {
        String orgCode = getOrgCode();
        return formInstanceEquipService.saveForm(groupCode, orgCode, map, instanceId);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "通用更新")
    @PutMapping(value = "/commonUpdate")
    public Object update(
            @RequestParam Long instanceId,
            @RequestParam(value = "groupCode", required = false) String groupCode,
            @RequestBody Map<String, Object> map) {
        String orgCode = getOrgCode();
        return formInstanceEquipService.updateForm(instanceId, orgCode, map, groupCode);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "删除")
    @DeleteMapping(value = "/{instanceId}")
    public Boolean delete(@PathVariable Long instanceId) {
        return formInstanceEquipService.deleteInstanceById(instanceId);
    }
}


