package com.yeejoin.amos.fas.business.controller;

import com.yeejoin.amos.fas.business.param.FmeaBindParam;
import com.yeejoin.amos.fas.business.service.intfc.EquipmentSpecificService;
import com.yeejoin.amos.fas.business.service.intfc.IEquipmentCategoryService;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import com.yeejoin.amos.fas.dao.entity.EquipmentCategory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zjw
 * @date 2020-11-04
 */

@RestController
@RequestMapping(value = "/api/equipment")
@Api(tags = "重点设备配套设施调整Api")

public class EquipmentSpecificController  extends AbstractBaseController{

    @Autowired
    private EquipmentSpecificService equipmentSpecificService;

    @Autowired
    private IEquipmentCategoryService iEquipmentCategoryService;



    @ApiOperation(value = "绑定消防设备指标", notes = "绑定消防设备指标")
    @PostMapping(value = "/upDateEquimentPoint")
    public CommonResponse upDateEquimentPoint(@RequestBody FmeaBindParam fmeaBindParam) {
        return CommonResponseUtil.success(equipmentSpecificService.upDateEquimentPoint(fmeaBindParam));
    }


    @ApiOperation(httpMethod = "GET", value = "查询指定风险点绑定关系", notes = "查询指定风险点绑定关系")
    @RequestMapping(value = "/getAssoEquips", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse getAssoEquips(
                                             @RequestParam Long fmeaId,
                                             @RequestParam int pageNumber,
                                             @RequestParam int pageSize) {
        return CommonResponseUtil.success(equipmentSpecificService.getAssoEquips(fmeaId, pageNumber, pageSize));
    }


    @ApiOperation(value = "查询设备指标", notes = "查询设备指标")
    @GetMapping(value = "/getBindEquipment")
    public CommonResponse getBindEquipment(@RequestParam Long fmeaId,
                                                 @RequestParam Long importantEquipId,
                                                 @RequestParam Long equimentId,
                                                 @RequestParam(required = false) String equipmentPointName) {
        return CommonResponseUtil.success(equipmentSpecificService.getBindEquipment(fmeaId, importantEquipId, equimentId, equipmentPointName));
    }



    @GetMapping(value = "/fireequiment")
    @ApiOperation(httpMethod = "GET", value = "查询绑定关系设备", notes = "查询绑定关系设备")
    public CommonResponse getFireEquiments(
            @RequestParam(value = "equipmentId") String equipmentId,
            @RequestParam(value = "fname",required = false) String fname)  {
        return CommonResponseUtil.success(equipmentSpecificService.getFireEquiments( equipmentId, fname));
    }

    @GetMapping(value = "/getEquipmentBySpe")
    @ApiOperation(httpMethod = "GET", value = "获取装备台账信息", notes = "获取装备台账信息")
    public CommonResponse getEquipmentBySpe(
            @RequestParam(value = "name",required = false) String name,
            @RequestParam(value = "code",required = false) String code,
            @RequestParam(value = "pageNumber",required = false) int pageNumber,
            @RequestParam(value = "pageSize",required = false) int pageSize,
            @RequestParam(value = "equipmentId",required = false) String equipmentId ) {
        return  CommonResponseUtil.success(equipmentSpecificService.getEquipmentBySpe(name, code, pageNumber, pageSize,equipmentId));
    }

    @GetMapping(value = "/getEquipmentBySpeV2")
    @ApiOperation(httpMethod = "GET", value = "获取装备台账信息", notes = "获取装备台账信息")
    public CommonResponse getEquipmentBySpeV2(
            @RequestParam(value = "name",required = false) String name,
            @RequestParam(value = "pageNumber",required = false) int pageNumber,
            @RequestParam(value = "pageSize",required = false) int pageSize,
            @RequestParam(value = "equipmentId",required = false) String  equipmentId ) {
        Long aLong = null;
        if (!"null".equals(equipmentId) && equipmentId != null && !"".equals(equipmentId.trim())){
             aLong = Long.valueOf(equipmentId);
        }
        return  CommonResponseUtil.success(equipmentSpecificService.getEquipmentBySpeV2(name, pageNumber, pageSize,aLong));
    }

    @GetMapping(value = "/list-tree", produces = "application/json;charset=UTF-8")
    @ApiOperation(httpMethod = "GET", value = "全量数据树形结构返回", notes = "全量数据树形结构返回")
    public CommonResponse getTreelist()  {
        List<EquipmentCategory> equipmentCategorys = iEquipmentCategoryService.list();
        List<EquipmentCategory> list = new ArrayList<>();
        Map<String, List<EquipmentCategory>> tmpMap = new HashMap<String, List<EquipmentCategory>>();
        equipmentCategorys.forEach(action -> {
            if (action.getParentId() == null) {
                list.add(action);
            } else {
                if (tmpMap.get(action.getParentId().toString()) == null) {
                    ArrayList<EquipmentCategory> tmplist = new ArrayList<EquipmentCategory>();
                    tmplist.add(action);
                    tmpMap.put(action.getParentId().toString(), tmplist);
                } else {
                    if (!tmpMap.get(action.getParentId().toString()).contains(action)) {
                        tmpMap.get(action.getParentId().toString()).add(action);
                    }
                }

            }
        });
        getChildren(list, tmpMap);
        return CommonResponseUtil.success(list);
    }


    private void getChildren(List<EquipmentCategory> list, Map<String, List<EquipmentCategory>> tmpMap) {
        for (EquipmentCategory equipmentCategory : list) {
            if (tmpMap.get(equipmentCategory.getId().toString()) != null
                    && tmpMap.get(equipmentCategory.getId().toString()).size() > 0) {
                List<EquipmentCategory> equipcliss = tmpMap.get(equipmentCategory.getId().toString());
                equipmentCategory.setHasLowerClassification(true);
                equipmentCategory.setChildren(equipcliss);
                getChildren(equipcliss, tmpMap);
            }
        }
    }

}
