package com.yeejoin.amos.boot.module.jcs.biz.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.boot.module.common.api.entity.MaintenanceCompany;
import com.yeejoin.amos.boot.module.common.biz.service.impl.WaterResourceServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.MenuFrom;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.EquipmentServiceImpl;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 装备服务接口
 *
 * @author DELL
 */
@RestController
@Api(tags = "装备服务Api")
@RequestMapping(value = "/equip")
public class EquipmentController extends BaseController {

    @Autowired
    EquipmentServiceImpl equipmentService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/fireSystem/list")
    @ApiOperation(value = "获取消防系统列表")
    public ResponseModel<List<MenuFrom>> getFireSystemList() {
        return ResponseHelper.buildResponse(equipmentService.getFireSystemList());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/building/tree")
    @ApiOperation(value = "获取消防建筑树")
    public ResponseModel<List<MenuFrom>> getBuildingList() {
        return ResponseHelper.buildResponse(equipmentService.getBuildingList());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/fireSystem_waterResource/list")
    @ApiOperation(value = "获取消防系统消防水源列表")
    public ResponseModel<List<MenuFrom>> getFireSystemWaterResourceList() {
        return ResponseHelper.buildResponse(equipmentService.getFireSystemWaterResourceList());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getMaintenanceId")
    @ApiOperation(value = "查询人员绑定维保单位id")
    public ResponseModel<Long> getMaintenanceId(@RequestParam() String userId) {
        return ResponseHelper.buildResponse(equipmentService.getMaintenanceId(userId));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/water/resource")
    @ApiOperation(value = "查询人员绑定维保单位id")
    public ResponseModel getWaterResourceList(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode) {
        return ResponseHelper.buildResponse(equipmentService.getWaterResourceInfoList(bizOrgCode));
    }


    /**
     * 获取驻站消防员和运维人员数量
     * @param
     * @returnP
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/resources/count", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "消防资源部分数据-四横八纵", notes = "消防资源部分数据-四横八纵")
    public ResponseModel<Map<String, Object>> getResourcesCount() {
        Map<String, Object> map = equipmentService.getResourcesCount();
        return ResponseHelper.buildResponse(map);
    }
}
