package com.yeejoin.amos.maintenance.business.dao.repository;

import java.util.List;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import com.yeejoin.amos.maintenance.dao.entity.CheckShot;

@Repository("checkShotDao")
public interface ICheckShotDao extends BaseDao<CheckShot, Long> {


	/**
	 * 检查项照片
	 * @param checkId
	 * @param checkInputId
	 * @return
	 */
	List<CheckShot> findAllByCheckIdAndCheckInputIdAndClassifyId(@Param("checkId") Long checkId, @Param("checkInputId") Long checkInputId, @Param("classifyId") Long classifyId);

	/**
	 * 检查项照片
	 *
	 * @param checkId
	 * @param checkInputId
	 * @return
	 */
	List<CheckShot> findAllByCheckIdAndCheckInputId(Long checkId, Long checkInputId);
}
