package com.yeejoin.amos.maintenance.business.param;

import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

import java.util.HashMap;

public class PageParam<K, V> extends HashMap<K, V> implements Pageable {

    /**
     * 页号（大于等于0）
     */
    protected int pageNumber = 0;

    /**
     * 每页大小（大于等于0）
     */
    protected int pageSize = 10;

    /**
     * 起始索引
     */
    protected int offset = 0;

    /**
     * 排序
     */
    protected Sort sort = null;

    public PageParam() {
        this.pageNumber = 0;
        this.pageSize = 10;
        this.offset = pageSize * pageNumber;
    }

    public PageParam(int pageNumber, int pageSize) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.offset = pageSize * pageNumber;
    }

    public PageParam(int pageNumber, int pageSize, Sort sort) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.sort = sort;
        this.offset = pageSize * pageNumber;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getPageSize() {
        return pageSize;
    }

    public long getOffset() {
        offset = pageSize * pageNumber;
        return offset;
    }

    public Sort getSort() {
        return sort;
    }

    public Pageable next() {
        return null;
    }

    public Pageable previousOrFirst() {
        return null;
    }

    public Pageable first() {
        return null;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }
}
