package com.yeejoin.amos;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.scheduling.annotation.EnableAsync;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Collections;

/**
 * <pre>
 * 服务启动类
 * </pre>
 *
 * @author amos
 * @version $Id: YeeAMOSPatrolStart.java, v 0.1 2018年11月26日 下午4:56:29 amos Exp $
 */
@SpringBootApplication
@EnableConfigurationProperties
@ServletComponentScan
@EnableDiscoveryClient
@EnableFeignClients
@EnableAsync
@EnableEurekaClient
@ComponentScan({"org.typroject","com.yeejoin.amos"})
public class AmosBootUtilsMessageApplication {

    private static final Logger logger = LoggerFactory.getLogger(AmosBootUtilsMessageApplication.class);

    public static void main(String[] args) throws UnknownHostException {
        SpringApplication application = new SpringApplication(AmosBootUtilsMessageApplication.class);
        ConfigurableEnvironment environment = new StandardEnvironment();
        int randomClientId = new SecureRandom().nextInt(65536 - 1024) + 1024;
        environment.getPropertySources().addFirst(new MapPropertySource("securityRandomSource",
                Collections.singletonMap("security-random-int", randomClientId)));
        application.setEnvironment(environment);
        application.run();
        String appName = environment.getProperty("spring.application.name");
        logger.info(
                "\n----------------------------------------------------------\n\t"
                        + "Application {} is running!\n"
                        + "----------------------------------------------------------\n"
                , appName
        );
    }

}
