package com.yeejoin.equip;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.typroject.tyboot.core.restful.exception.GlobalExceptionHandler;

import java.net.InetAddress;

/**
 * @author LiuLin
 * @date 2023/6/25
 * @apiNote 启动类
 */
@SpringBootApplication
@EnableTransactionManagement
@EnableConfigurationProperties
@ServletComponentScan
@EnableDiscoveryClient
@EnableFeignClients
@EnableAsync
@EnableEurekaClient
@EnableScheduling
@MapperScan(value = { "org.typroject.tyboot.*.*.face.orm.dao", "com.yeejoin.amos.api.*.face.orm.dao", "org.typroject.tyboot.face.*.orm.dao*",
		"com.yeejoin.equip.mapper","com.yeejoin.amos.boot.biz.common.dao.mapper" })
@ComponentScan({ "org.typroject", "com.yeejoin.equip","com.yeejoin.amos" })
public class EquipDataApplication {

	private static final Logger logger = LogManager.getLogger(EquipDataApplication.class);

	public static void main(String[] args) {
		ConfigurableApplicationContext context = SpringApplication.run(EquipDataApplication.class, args);
		GlobalExceptionHandler.setAlwaysOk(true);
		Environment env = context.getEnvironment();
		String appName = env.getProperty("spring.application.name");
		logger.info(
				"\n----------------------------------------------------------\n\t"
						+ "Application {} is running!\n"
						+ "----------------------------------------------------------\n"
				, appName
		);
	}
}
