package com.yeejoin.amos.api.openapi.controller;

import com.yeejoin.amos.api.common.restful.utils.ResponseHelper;
import com.yeejoin.amos.api.common.restful.utils.ResponseModel;
import com.yeejoin.amos.api.openapi.face.model.*;
import com.yeejoin.amos.api.openapi.face.service.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.component.event.RestEventTrigger;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping(value = "/csei")
@Api(tags = "csei-检验检测数据对接")
public class CseiController {
	private static final  Logger logger = LogManager.getLogger(CseiController.class);
	
	@Autowired
	private SpecialBoilerService specialBoilerService;
	@Autowired
	private SpecialConstructionInfoService specialConstructionInfoService;
	@Autowired
	private SpecialCraneService specialCraneService;
	@Autowired
	private SpecialElevatorService specialElevatorService;
	@Autowired
	private SpecialEquService specialEquService;
	@Autowired
	private SpecialInspectService specialInspectService;
	@Autowired
	private SpecialPassengerRopewayService specialPassengerRopewayService;
	@Autowired
	private SpecialPresContainerService specialPresContainerService;
	@Autowired
	private SpecialRecreationFacilityService specialRecreationFacilityService;
	@Autowired
	private SpecialUnitService specialUnitService;
	@Autowired
	private SpecialVehicleService specialVehicleService;
	
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "单位信息")
	@PostMapping(value = "/unitInfo")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> cseiUnit (
			@RequestBody String unitData) throws Exception 
	{
		
		logger.info("单位信息"+unitData);
		JSONObject jsonobject = JSONObject.fromObject(unitData);
		Map<String, Class> classMap = new HashMap<String, Class>();
		classMap.put("unitInfo", SpecialUnitModel.class);
		SpecialUnitModelList specialUnitModelList = (SpecialUnitModelList) JSONObject.toBean(jsonobject,
				SpecialUnitModelList.class, classMap);
		specialUnitService.createSpecialUnit(specialUnitModelList.getUnitInfo());
		return ResponseHelper.buildResponse("");
	}
	
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "设备基本数据")
	@PostMapping(value = "/equInfo")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> equInfo (
			@RequestBody String equInfoData) throws Exception 
	{
		
		logger.info("设备基本数据"+equInfoData);
		JSONObject jsonobject = JSONObject.fromObject(equInfoData);
		Map<String, Class> classMap = new HashMap<String, Class>();
		classMap.put("equInfo", SpecialEquModel.class);
		SpecialEquModelList specialEquModelList = (SpecialEquModelList) JSONObject.toBean(jsonobject,
				SpecialEquModelList.class, classMap);
		specialEquService.createSpecialEqu(specialEquModelList.getEquInfo());
		return ResponseHelper.buildResponse("");
	}
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "锅炉信息")
	@PostMapping(value = "/boilerInfo")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> boilerInfo (
			@RequestBody String boilerData) throws Exception 
	{
		
		logger.info("锅炉信息"+boilerData);
		JSONObject jsonobject = JSONObject.fromObject(boilerData);
		Map<String, Class> classMap = new HashMap<String, Class>();
		classMap.put("boilerInfo", SpecialBoilerModel.class);
		SpecialBoilerModelList specialBoilerModelList = (SpecialBoilerModelList) JSONObject.toBean(jsonobject,
				SpecialBoilerModelList.class, classMap);
		specialBoilerService.createSpecialBoiler(specialBoilerModelList.getBoilerInfo());
		return ResponseHelper.buildResponse("");
	}
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "压力容器信息")
	@PostMapping(value = "/presContainerInfo")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> presContainerInfo (
			@RequestBody String presContainerData) throws Exception 
	{
		
		logger.info("压力容器信息"+presContainerData);
		JSONObject jsonobject = JSONObject.fromObject(presContainerData);
		Map<String, Class> classMap = new HashMap<String, Class>();
		classMap.put("presContainerInfo", SpecialPresContainerModel.class);
		SpecialPresContainerModelList specialPresContainerModelList = (SpecialPresContainerModelList) JSONObject.toBean(jsonobject,
				SpecialPresContainerModelList.class, classMap);
		specialPresContainerService.createSpecialPresContainer(specialPresContainerModelList.getPresContainerInfo());
		return ResponseHelper.buildResponse("");
	}
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "电梯信息")
	@PostMapping(value = "/elevatorInfo")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> elevatorInfo (
			@RequestBody String elevatorData) throws Exception 
	{
		
		logger.info("电梯信息"+elevatorData);
		JSONObject jsonobject = JSONObject.fromObject(elevatorData);
		Map<String, Class> classMap = new HashMap<String, Class>();
		classMap.put("elevatorInfo", SpecialElevatorModel.class);
		SpecialElevatorModelList specialElevatorModelList = (SpecialElevatorModelList) JSONObject.toBean(jsonobject,
				SpecialElevatorModelList.class, classMap);
		specialElevatorService.createSpecialElevator(specialElevatorModelList.getElevatorInfo());
		return ResponseHelper.buildResponse("");
	}
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "起重机械信息")
	@PostMapping(value = "/craneInfo")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> craneInfo (
			@RequestBody String craneData) throws Exception 
	{
		
		logger.info("起重机械信息"+craneData);
		JSONObject jsonobject = JSONObject.fromObject(craneData);
		Map<String, Class> classMap = new HashMap<String, Class>();
		classMap.put("craneInfo", SpecialCraneModel.class);
		SpecialCraneModelList specialCraneModelList = (SpecialCraneModelList) JSONObject.toBean(jsonobject,
				SpecialCraneModelList.class, classMap);
		specialCraneService.createSpecialCrane(specialCraneModelList.getCraneInfo());
		return ResponseHelper.buildResponse("");
	}
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "厂（场）内机动车辆")
	@PostMapping(value = "/vehicleInfo")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> vehicleInfo (
			@RequestBody String boilerData) throws Exception 
	{
		
		logger.info("厂（场）内机动车辆"+boilerData);
		JSONObject jsonobject = JSONObject.fromObject(boilerData);
		Map<String, Class> classMap = new HashMap<String, Class>();
		classMap.put("vehicleInfo", SpecialVehicleModel.class);
		SpecialVehicleModelList specialVehicleModelList = (SpecialVehicleModelList) JSONObject.toBean(jsonobject,
				SpecialVehicleModelList.class, classMap);
		specialVehicleService.createSpecialVehicle(specialVehicleModelList.getVehicleInfo());
		return ResponseHelper.buildResponse("");
	}
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "游乐设施信息")
	@PostMapping(value = "/recreationFacilityInfo")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> recreationFacilityInfo (
			@RequestBody String recreationFacilityData) throws Exception 
	{
		
		logger.info("游乐设施信息"+recreationFacilityData);
		JSONObject jsonobject = JSONObject.fromObject(recreationFacilityData);
		Map<String, Class> classMap = new HashMap<String, Class>();
		classMap.put("recreationFacilityInfo", SpecialRecreationFacilityModel.class);
		SpecialRecreationFacilityModelList specialRecreationFacilityModelList = (SpecialRecreationFacilityModelList) JSONObject.toBean(jsonobject,
				SpecialRecreationFacilityModelList.class, classMap);
		specialRecreationFacilityService.createSpecialRecreationFacility(specialRecreationFacilityModelList.getRecreationFacilityInfo());
		return ResponseHelper.buildResponse("");
	}
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "客运索道信息")
	@PostMapping(value = "/passengerInfo")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> passengerInfo (
			@RequestBody String passengerData) throws Exception 
	{
		
		logger.info("客运索道信息"+passengerData);
		JSONObject jsonobject = JSONObject.fromObject(passengerData);
		Map<String, Class> classMap = new HashMap<String, Class>();
		classMap.put("passengerInfo", SpecialPassengerRopewayModel.class);
		SpecialPassengerRopewayModelList specialPassengerRopewayModelList = (SpecialPassengerRopewayModelList) JSONObject.toBean(jsonobject,
				SpecialPassengerRopewayModelList.class, classMap);
		specialPassengerRopewayService.createSpecialPassengerRopeway(specialPassengerRopewayModelList.getPassengerInfo());
		return ResponseHelper.buildResponse("");
	}
	
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "设备施工告知信息")
	@PostMapping(value = "/constructionInfo")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> constructionInfo (
			@RequestBody String constructionData) throws Exception 
	{
		
		logger.info("设备施工告知信息"+constructionData);
		JSONObject jsonobject = JSONObject.fromObject(constructionData);
		Map<String, Class> classMap = new HashMap<String, Class>();
		classMap.put("constructionInfo", SpecialConstructionInfoModel.class);
		SpecialConstructionInfoModelList specialConstructionInfoModelList = (SpecialConstructionInfoModelList) JSONObject.toBean(jsonobject,
				SpecialConstructionInfoModelList.class, classMap);
		specialConstructionInfoService.createSpecialConstructionInfo(specialConstructionInfoModelList.getConstructionInfo());
		return ResponseHelper.buildResponse("");
	}
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "检验信息")
	@PostMapping(value = "/inspectInfo")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> inspectInfo (
			@RequestBody String inspectData) throws Exception 
	{
		
		logger.info("检验信息"+inspectData);
		JSONObject jsonobject = JSONObject.fromObject(inspectData);
		Map<String, Class> classMap = new HashMap<String, Class>();
		classMap.put("inspectInfo", SpecialInspectModel.class);
		classMap.put("inspectReport", OpenapiFilesModel.class);
		SpecialInspectModelList specialInspectModelList = (SpecialInspectModelList) JSONObject.toBean(jsonobject,
				SpecialInspectModelList.class, classMap);
		specialInspectService.createSpecialInspect(specialInspectModelList.getInspectInfo());
		return ResponseHelper.buildResponse("");
	}
	
}
