package com.yeejoin.amos.api.openapi.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 特种设备基本信息-设计信息
 *
 * @author duanwei
 * @date 2022-07-20
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@TableName("tm_jg_design_info")
@ApiModel(value="TmJgDesignInfo对象", description="特种设备基本信息-设计信息")
public class DesignInfo extends AbstractBaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "设备唯一标识码")
    private String sequenceCode;

    @ApiModelProperty(value = "监管系统唯一编码(监管系统对接标识)")
    private String superviseCode;

    @ApiModelProperty(value = "设计单位统一社会信用代码")
    private String designUnitCreditCode;

    @ApiModelProperty(value = "设计单位名称")
    @TableField("design_Unit_name")
    private String designUnitName;

    @ApiModelProperty(value = "设计许可编号")
    private String designLicenseNum;

    @ApiModelProperty(value = "设计使用年限")
    private Integer designUseDate;

    @ApiModelProperty(value = "设计日期")
    private Date designDate;

    @ApiModelProperty(value = "总图图号")
    private String drawingDo;

    @ApiModelProperty(value = "设计文件鉴定单位")
    private String appraisalUnit;

    @ApiModelProperty(value = "设计文件鉴定日期")
    private Date appraisalDate;



}
