package com.yeejoin.amos.boot.module.ccs.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 消防设备资产
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FireEquipmentDto", description = "消防设备资产")
public class FireEquipmentDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "站点编码")
    private String stationCode;

    @ApiModelProperty(value = "站点名称")
    private String stationName;

    @ApiModelProperty(value = "实物id")
    private String mrid;

    @ApiModelProperty(value = "设备名称")
    private String name;

    @ApiModelProperty(value = "设备编码")
    private String code;

    @ApiModelProperty(value = "设备类别名称")
    private String categoryName;

    @ApiModelProperty(value = "设备类别编码")
    private String categoryCode;

    @ApiModelProperty(value = "设备图片")
    private String img;

    @ApiModelProperty(value = "设备物联编码")
    private String iotCode;

    @ApiModelProperty(value = "所属区域")
    private String workArea;

    @ApiModelProperty(value = "所在建筑id")
    private String buildMrid;

    @ApiModelProperty(value = "所属消防系统ids")
    private String fightingSystemMrids;

    @ApiModelProperty(value = "位置")
    private String position;

    @ApiModelProperty(value = "使用日期")
    private Date inUseDate;

    @ApiModelProperty(value = "是否为物联设备：0-否；1-是")
    private Boolean isIot;

    @ApiModelProperty(value = "状态")
    private String status;

    @ApiModelProperty(value = "使用状态")
    private String inUseState;

    @ApiModelProperty(value = "修改时间")
    private Date updateDate;

    @ApiModelProperty(value = "建筑名称")
    private String buildName;

    @ApiModelProperty(value = "物理区域id")
    private String areaMrid;

    @ApiModelProperty(value = "经度")
    private String lng;

    @ApiModelProperty(value = "纬度")
    private String lat;

}
