package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.excel.CommonExplicitConstraint;
import com.yeejoin.amos.boot.module.common.api.excel.ExplicitConstraint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author system_generator
 * @date 2021-06-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "WaterBaseResourceDto", description = "水资源")
public class WaterBaseResourceDto extends BaseDto {
	@ExcelIgnore
	@ApiModelProperty(value = "机构/部门名称")
	private String bizOrgName;

	@ExcelIgnore
	@ApiModelProperty(value = "机构编码")
	private String bizOrgCode;

	@ExcelIgnore
	private static final long serialVersionUID = 1L;

	@ExcelProperty(value = "名称", index = 0)
	@ApiModelProperty(value = "资源名称")
	private String name;

	@ExcelProperty(value = "地址", index = 1)
	@ApiModelProperty(value = "地址")
	private String address;

	@ExcelIgnore
	@ApiModelProperty(value = "资源类型（消火栓：hydrant、消防水鹤：crane、天然水源：natural、消防水池：pool）")
	private String resourceType;

	@ExplicitConstraint(type = "XFSYLX", indexNum = 2, sourceClass = CommonExplicitConstraint.class) // 动态下拉内容
	@ExcelProperty(value = "资源类型", index = 2)
	@ApiModelProperty(value = "资源类型名称（消火栓、消防水鹤、天然水源、消防水池）")
	private String resourceTypeName;

	@ExcelIgnore
	@ApiModelProperty(value = "所在建筑id")
	private Long belongBuildingId;

	@ExplicitConstraint(indexNum = 3, sourceClass = CommonExplicitConstraint.class, method = "getWaterBuildingList")
	@ExcelProperty(value = "所在建筑", index = 3)
	@ApiModelProperty(value = "所在建筑")
	private String belongBuilding;

	@ExcelIgnore
	@ApiModelProperty(value = "所属消防系统id")
	private Long belongFightingSystemId;

	@ExplicitConstraint(indexNum = 4, sourceClass = CommonExplicitConstraint.class, method = "getFireSystemList")
	@ExcelProperty(value = "所属消防系统", index = 4)
	@ApiModelProperty(value = "所属消防系统")
	private String belongFightingSystem;

	@ExcelIgnore
	@ApiModelProperty("设施定义id")
	private Long equipId;

	@ApiModelProperty("设施定义名称")
	@ExcelProperty(value = "设施定义名称", index = 5)
	@ExplicitConstraint(indexNum = 5, sourceClass = CommonExplicitConstraint.class, method = "getEquipDefinition")
	private String equipName;

	@ExcelIgnore
	@ApiModelProperty("设施分类id")
	private Long equipCategoryId;


	@ApiModelProperty("维保周期")
	@ExcelProperty(value = "维保周期(月)", index = 6)
	private String maintenancePeriod;

	@ExcelProperty(value = "建造日期", index = 7)
	@ApiModelProperty(value = "建造日期")
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date buildDate;

	@ExcelProperty(value = "启用日期", index = 8)
	@ApiModelProperty(value = "启用日期")
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date enableDate;

	@ExcelIgnore
	@ApiModelProperty(value = "管理单位id")
	private Long managementUnitId;

	@ExplicitConstraint(indexNum = 9, sourceClass = CommonExplicitConstraint.class, method = "getWaterCompanyList")
	@ExcelProperty(value = "管理单位", index = 9)
	@ApiModelProperty(value = "管理单位")
	private String managementUnit;

	@ExcelIgnore
	@ApiModelProperty(value = "维保单位id")
	private Long maintenanceUnitId;

	@ExplicitConstraint(indexNum = 10, sourceClass = CommonExplicitConstraint.class, method = "getCompanyList")
	@ExcelProperty(value = "维保单位", index = 10)
	@ApiModelProperty(value = "维保单位")
	private String maintenanceUnit;

	@ExplicitConstraint(indexNum =11, sourceClass = CommonExplicitConstraint.class, method = "getContactUser")
	@ExcelProperty(value = "联系人姓名", index = 11)
	@ApiModelProperty(value = "联系人姓名")
	private String contactUser;

	/**
	 * 联系人姓名id
	 */
	@ExcelIgnore
	@TableField("contact_user_id")
	private String contactUserId;

	@ExcelProperty(value = "联系人电话", index = 12)
	@ApiModelProperty(value = "联系人电话")
	private String contactPhone;

	@ApiModelProperty(value = "经度")
	@ExcelProperty(value = "经度", index = 13)
	private Double longitude;

	@ApiModelProperty(value = "纬度")
	@ExcelProperty(value = "纬度", index = 14)
	private Double latitude;

	@ExcelIgnore
	@ApiModelProperty(value = "是否有物联参数（1有，0没有）")
	private Boolean isIot;

	@ExcelIgnore
	@ApiModelProperty(value = "消防救援机构_通用唯一识别码")
	private String rescueOrgCode;

	@ExcelIgnore
	@ApiModelProperty(value = "行政区划代码")
	private String administrativeCode;

	@ExcelIgnore
	@ApiModelProperty(value = "更新人员")
	private String recUserName;

	@ExcelIgnore
	@ApiModelProperty(value = "组织机构代码")
	private String orgCode;

	@ExcelIgnore
	@ApiModelProperty(value = "资源id")
	private Long resourceId;

	// 物联参数改为动态加载，原先字段作废，字段做隐藏
	@ExcelIgnore
	@ApiModelProperty(value = "储水量容积物联编码")
	private String iotWaterStorage;

	@ExcelIgnore
	@ApiModelProperty(value = "流量物联编码")
	private String iotFlowRate;

	@ExcelIgnore
	@ApiModelProperty(value = "状态物联编码")
	private String iotStatus;

	// BUG 2920 管网压力字段冗余 2021-09-18 陈召
	@ExcelIgnore
	@ApiModelProperty(value = "管网压力物联编码")
	private String iotPipePressure;

	@ExcelIgnore
	@ApiModelProperty(value = "物联参数")
	private Map<String, Object> waterResourceIotDto;


	// BUG 2935 优化项 分类从93060000 取得字典数据 by kongfm 2021-09-17
	@ApiModelProperty("设施分类名称")
	@ExcelIgnore
	private String equipCategoryName;
	
	@ApiModelProperty("设施分类编码")
	@ExcelIgnore
	private String equipCategoryCode;

	@ApiModelProperty("设施编码")
	@ExcelIgnore
	private String equipCode;


	@ExcelIgnore
	@ApiModelProperty(value = "附件")
	@TableField(exist = false)
	private Map<String, List<AttachmentDto>> attachments;


}
