package com.yeejoin.amos.boot.module.common.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.common.api.dto.CompanyAttachFileDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

/**
 * @author keyong
 * @title: CompanyInfo
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2022/4/28 15:04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("cb_fire_company_info")
@ApiModel(value="CompanyInfo对象", description="公司信息")
public class CompanyInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "人员部门公司表主键")
    @TableField("instance_id")
    private Long instanceId;

    @ApiModelProperty(value = "占地面积")
    @TableField("floor_space")
    private String floorSpace;

    @ApiModelProperty(value = "负荷等级")
    @TableField("load_level")
    private String loadLevel;

    @ApiModelProperty(value = "室内管网形式")
    @TableField("indoor_pipe_network_type")
    private String indoorPipeNetworkType;

    @ApiModelProperty(value = "室外管网形式")
    @TableField("outdoor_pipe_network_type")
    private String outdoorPipeNetworkType;

    @ApiModelProperty(value = "安全出口总数")
    @TableField("exit_num")
    private String exitNum;

    @ApiModelProperty(value = "疏散楼梯数")
    @TableField("stairs_num")
    private String stairsNum;

    @ApiModelProperty(value = "毗邻单位东")
    @TableField("position_info_direction_east")
    private String positionInfoEast;

    @ApiModelProperty(value = "毗邻单位西")
    @TableField("position_info_direction_west")
    private String positionInfoWest;

    @ApiModelProperty(value = "毗邻单位南")
    @TableField("position_info_direction_south")
    private String positionInfoSouth;

    @ApiModelProperty(value = "毗邻单位北")
    @TableField("position_info_direction_north")
    private String positionInfoNorth;

    @ApiModelProperty(value = "消防设施平面图")
    @TableField("fire_equip_file")
    private String fireEquipFile;

    @ApiModelProperty(value = "消防设计审核文件")
    @TableField("fire_design_check_file")
    private String fireDesignCheckFile;

    @ApiModelProperty(value = "消防设计验收文件")
    @TableField("fire_design_acceptance_file")
    private String fireDesignAcceptanceFile;

    @ApiModelProperty(value = "消防安全检查文件")
    @TableField("fire_safe_check_file")
    private String fireSafeCheckFile;

    @ApiModelProperty(value = "其他文件")
    @TableField("others_file")
    private String othersFile;

    @ApiModelProperty(value = "创建时间")
    @TableField("rec_date")
    private Date createDate;
}
