package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentOnCarAppVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 消防车信息
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value="wl_car_speed_warning_record",autoResultMap = true)
@ApiModel(value = "车辆告警信息实体类", description = "车辆告警信息")
public class CarSpeedWarningRecord extends BaseEntity {

	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "车牌号")
	private String carNum;
	@ApiModelProperty(value = "告警时间")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date waringDate;
	@ApiModelProperty(value = "超速值")
	@TableField("over_speed")
	private Double overSpeed;
	@ApiModelProperty(value = "机构/部门名称")
	@TableField("biz_org_name")
	private String bizOrgName;
    // 2023年11月6日 11点16分添加
	@ApiModelProperty(value = "司机")
	@TableField("driver")
	private String driver;
	// 2023年11月6日 11点16分添加
	@ApiModelProperty(value = "联系电话")
	@TableField("phone")
	private String phone;
	@ApiModelProperty(value = "联系电话")
	@TableField("ownership")
	private String ownership;
	@ApiModelProperty(value = "超速时间到分钟")
	@TableField("waring_date_minute")
	private String waringDateMinute;
	@ApiModelProperty(value = "超速次数")
	@TableField("over_speed_count")
	private Integer overSpeedCount;
}
