package com.yeejoin.amos.fas.dao.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;


/**
 * The persistent class for the risk_factors database table.
 * 
 */
@Entity
@Table(name="f_risk_factor")
@NamedQuery(name="RiskFactor.findAll", query="SELECT r FROM RiskFactor r")
public class RiskFactor extends BasicEntity  {
	private static final long serialVersionUID = 1L;

	@Column(name="accident_type_id")
	private Long accidentTypeId;

	@Column(name="create_by")
	private String createBy;

	@Column(name="dept_id")
	private String deptId;

	private String name;

	@Column(name="org_code")
	private String orgCode;

	private String remark;

	private String type;

	public RiskFactor() {
	}

	public Long getAccidentTypeId() {
		return this.accidentTypeId;
	}

	public void setAccidentTypeId(Long accidentTypeId) {
		this.accidentTypeId = accidentTypeId;
	}

	public String getCreateBy() {
		return this.createBy;
	}

	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}

	public String getDeptId() {
		return this.deptId;
	}

	public void setDeptId(String deptId) {
		this.deptId = deptId;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getOrgCode() {
		return this.orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getRemark() {
		return this.remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

}