package com.yeejoin.amos.boot.module.jcs.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 机场机位旋转角度
 *
 * @author litw
 * @date 2021-09-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="AirportStandDto", description="机场机位旋转角度")
public class AirportStandDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "机位号")
    private String standCode;

    @ApiModelProperty(value = "坐标X")
    private String coordinateX;

    @ApiModelProperty(value = "坐标Y")
    private String coordinateY;

    @ApiModelProperty(value = "经度")
    private String longitude;

    @ApiModelProperty(value = "纬度")
    private String latitude;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

}
