package com.yeejoin.amos.knowledgebase.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import java.util.Date;

/**
 * <p>
 * 知识库文档注释
 * </p>
 *
 * @author ningtianqing
 * @since 2020-09-16
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("knowledge_doc_annotate")
public class KnowledgeDocAnnotate extends BaseEntity {


    /**
     * 文档id
     */
    @TableField("DOC_SEQ")
    private Long docSeq;
    /**
     * 添加注释的用户id
     */
    @TableField("USER_ID")
    private String userId;
    /**
     * 注释内容
     */
    @TableField("ANNOTATE_CONTENT")
    private String annotateContent;
    /**
     * 注释位置信息（前端定义和使用的内容）
     */
    @TableField("POSITION_INFO")
    private String positionInfo;
    /**
     * 创建时间
     */
    @TableField("CREATE_TIME")
    private Date createTime;
    /**
     * 机构编号
     */
    @TableField("AGENCY_CODE")
    private String agencyCode;
}

