package com.yeejoin.amos.latentdanger.dao.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import java.util.Date;

/**
 * @author keyong
 * @title: LatentDangerFlowRecord
 * <pre>
 * @description: 隐患工作流记录表
 * </pre>
 * @date 2021/1/26 14:18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("p_latent_danger_flow_record")
@ApiModel(value="LatentDangerFlowRecord", description="隐患工作流记录信息")
public class LatentDangerFlowRecord extends BasicEntity {
    private static final long serialVersionUID = 1L;

    @Column(name = "danger_id")
    private Long dangerId;

    @Column(name = "action_flag")
    private String actionFlag;

    @Column(name = "flow_task_name")
    private String flowTaskName;

    @Column(name = "flow_task_user_ids")
    private String flowTaskUserIds;

    @Column(name = "flow_task_id")
    private String flowTaskId;

    @Column(name = "execute_state")
    private Integer executeState;

    @Column(name = "execute_user_id")
    private String executeUserId;

    @Column(name = "execute_user_name")
    private String executeUserName;

    @Column(name = "execute_result")
    private String executeResult;

    @Column(name = "remark")
    private String remark;

    @Column(name = "flow_json")
    private String flowJson;

    /**
     * 是否删除（0：否；1：是）
     */
    @Column(name = "deleted")
    private Boolean deleted = false;

    /**
     * 记录修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    @Column(name = "execute_department_id")
    private String executeDepartmentId;

    @Column(name = "execute_department_name")
    private String executeDepartmentName;

}
