package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.github.liangbaika.validate.annations.AbcValidate;
import com.github.liangbaika.validate.enums.Check;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 企业工商信息
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("rpm_company_business")
@ApiModel(value = "CompanyBusiness对象", description = "企业工商信息")
public class CompanyBusiness extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "公司id")
    private Long companyId;
    @ApiModelProperty(value = "统一社会信用代码")
    private String creditCode;
    @ApiModelProperty(value = "编号")
    @AbcValidate(fun = Check.le, express = "100")
    private String code;
    @ApiModelProperty(value = "类型")
    private String type;
    @ApiModelProperty(value = "法定代表人")
    private String legalRepresentative;
    @ApiModelProperty(value = "注册资本")
    private Integer registerCapital;
    @ApiModelProperty(value = "注册资本单位( 0-元 1-美元)")
    @AbcValidate(fun = Check.le, express = "20")
    private String registerCapitalUnitKey;
    @ApiModelProperty(value = "成立日期")
    private Date establishDate;
    @ApiModelProperty(value = "营业期限是否永久")
    private Integer permanent;
    @ApiModelProperty(value = "营业开始时间")
    @TableField(insertStrategy = FieldStrategy.IGNORED, updateStrategy = FieldStrategy.IGNORED)
    private Date businessStartDate;
    @ApiModelProperty(value = "营业结束时间")
    @TableField(insertStrategy = FieldStrategy.IGNORED, updateStrategy = FieldStrategy.IGNORED)
    private Date businessEndDate;
    @ApiModelProperty(value = "发证日期")
    private Date athDate;
    @ApiModelProperty(value = "登记机关")
    private String registerAuthority;
    @ApiModelProperty(value = "住所")
    @AbcValidate( fun = Check.le, express = "50")
    private String companyAddress;
    @ApiModelProperty(value = "经营范围")
    @AbcValidate(fun = Check.le, express = "200")
    private String businessScope;
    private Integer businessStatus;
    @ApiModelProperty(value = "营业执照")
    private String businessLicense;
    @ApiModelProperty(value = "附件")
    @TableField(exist = false)
    @ImagePrefix
    private List<CompanyBusinessAttachment> attachment;
}
