package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 人员技能和学历
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("rpm_person_skill_education")
@ApiModel(value = "PersonSkillEducation对象", description = "人员技能和学历")
public class PersonSkillEducation extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "人员信息id")
    private Long personId;
    @ApiModelProperty(value = "是否特殊工种")
    private Integer isSpecialWork;
    @ApiModelProperty(value = "工种名称/特殊工种名称")
    private String workName;
    @ApiModelProperty(value = "技能鉴定工种key")
    private String workTypeKey;
    @ApiModelProperty(value = "专业技术资格key")
    private String professionalTechnologyKey;
    @ApiModelProperty(value = "技能等级key")
    private String skillLevelKey;
    @ApiModelProperty(value = "初始学历key")
    private String initialEducationKey;
    @ApiModelProperty(value = "现学历key")
    private String currentEducationKey;
    @ApiModelProperty(value = "现学历学校名称")
    private String currentSchool;
    @ApiModelProperty(value = "现学历所学专业")
    private String currentMajor;
    @ApiModelProperty(value = "岗位执业鉴定证书")
    private String professionalQualificationCertificate;
    @ApiModelProperty(value = "岗位职业鉴定证书")
    private String professionalCertificationPosition;
    @ApiModelProperty(value = "专业技术资格等级key")
    private String professionalTechnologyLevelKey;

}
