package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author duanwei
 * @date 2020-07-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_task_paycheck")
@ApiModel(value = "TaskPaycheck对象", description = "")
public class TaskPaycheck extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "施工任务")
    private Long constructionTask;
    @ApiModelProperty(value = "技术要求")
    private Long technicalRequire;
    @ApiModelProperty(value = "安全环保措施")
    private Long environmentProtect;
    @ApiModelProperty(value = "着装")
    private Long dress;
    @ApiModelProperty(value = "三宝(安全帽、安全带、安全鞋)")
    private Long saftTreasure;
    @ApiModelProperty(value = "精神状态")
    private Long mentalState;
    @ApiModelProperty(value = "任务id")
    private Long taskId;
    @ApiModelProperty(value = "是否风险作业")
    private Long riskOperation;
    @ApiModelProperty(value = "风险作业类型ID")
    private Long riskTypeId;
    @ApiModelProperty(value = "风险作业类型")
    private String riskType;
    @ApiModelProperty(value = "作业票id")
    private Long workTicketId;
    @ApiModelProperty(value = "作业票名称")
    private String workTicketName;
}
