package com.yeejoin.precontrol.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.precontrol.common.constant.Constant;
import com.yeejoin.precontrol.common.entity.BadManagement;
import com.yeejoin.precontrol.common.entity.TaskPersonFile;
import com.yeejoin.precontrol.common.mapper.BadManagementMapper;
import com.yeejoin.precontrol.common.mapper.TaskPersonFileMapper;
import com.yeejoin.precontrol.common.service.IBadManagementService;
import com.yeejoin.precontrol.common.utils.RedisUtil;
import com.yeejoin.precontrol.common.vo.BadManagementVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 服务实现类
 *
 * @author duanwei
 * @date 2020-07-06
 */
@Service
public class BadManagementServiceImpl extends ServiceImpl<BadManagementMapper, BadManagement> implements IBadManagementService {

    @Autowired
    private BadManagementMapper badManagementMapper;

    @Autowired
    private TaskPersonFileMapper taskPersonFileMapper;

    @Autowired
    RedisUtil redisUtil;

    @Override
    public int selectCountByPersonId(Long personId) {
        return badManagementMapper.selectCountByPersonId(personId);
    }

    @Override
    public List<Object> violationSum(String orgCode, Long projectId) {
        List<Object> list = new ArrayList<>();
        List<String> valList = (List<String>) redisUtil.get(Constant.VIOLATION_NATURE);
        List<Object> objects = badManagementMapper.violationSum(orgCode, projectId);
        // 获取redis缓存 的违章类型
        if (valList != null && valList.size() > 0) {
            processViolationNaturetype(valList, objects, list);
        } else {
            // 获取redis缓存的违章类型 失败 临时补充写死类型
            List<String> listTemp = new ArrayList<>();
            listTemp.add("一类违章");
            listTemp.add("二类违章");
            listTemp.add("三类违章");
            listTemp.add("四类违章");
            listTemp.add("五类违章");
            listTemp.add("六类违章");
            processViolationNaturetype(listTemp, objects, list);
        }
        return list;
    }

    @Override
    public Page<BadManagementVo> pageList(Long current, Long size, String companyId) {
        Page<BadManagementVo> page = new Page<>(current, size);
        Page<BadManagementVo> badManagementVoPage = badManagementMapper.pageList(page, companyId);
        badManagementVoPage.getRecords().forEach(badManagementVo -> {
            QueryWrapper<TaskPersonFile> wrapper = new QueryWrapper<TaskPersonFile>().eq("task_id", badManagementVo.getTaskId());
            List<TaskPersonFile> taskPersonList = taskPersonFileMapper.selectList(wrapper);
            taskPersonList.forEach(taskPersonFile -> {
                List<String> filesPath = badManagementVo.getFilesPath();
                if (filesPath == null) filesPath = new ArrayList<>();
                filesPath.add(taskPersonFile.getFilePath());
                badManagementVo.setFilesPath(filesPath);
            });
        });
        return badManagementVoPage;
    }

    /**
     * 处理违章类型 统计数据
     *
     * @param valList 类型
     * @param objects 统计数据
     * @param ret     处理结果数据
     */
    public void processViolationNaturetype(List<String> valList, List<Object> objects, List<Object> ret) {
        for (String type : valList) {
            Map map = new HashMap();
            // 查询数据是否有该类型的数据统计值
            if (objects != null && objects.size() > 0) {
                boolean flag = true;
                for (Object object : objects) {
                    Map m = (Map) object;
                    if (type.equals(m.get("nature"))) {
                        map.put("type", type);
                        map.put("num", m.get("num"));
                        flag = false;
                    }
                }
                // 没有则补 0
                if (flag) {
                    map.put("type", type);
                    map.put("num", "0");
                }
            } else {
                map.put("type", type);
                map.put("num", "0");
            }
            ret.add(map);
        }
    }
}
