package com.yeejoin.precontrol.common.task;

import com.yeejoin.precontrol.common.start.StartPlatformTokenService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * @author DELL
 */
@Component
@EnableScheduling
@Slf4j
public class PlatFormTokenTask {

	@Autowired
	StartPlatformTokenService startPlatformTokenService;

	@Scheduled(cron = "0 0 1 * * ?")
	public void getToken() {
		log.info("定时任务刷新token开始--------------->");
		startPlatformTokenService.getToken();
		log.info("定时任务刷新token结束--------------->");
	}
}
