package com.yeejoin.precontrol.common.task;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.precontrol.common.entity.Project;
import com.yeejoin.precontrol.common.entity.ProjectScore;
import com.yeejoin.precontrol.common.service.IProjectScoreService;
import com.yeejoin.precontrol.common.service.IProjectService;
import com.yeejoin.precontrol.common.utils.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * @description:
 * @author: duanwei
 * @date: 2020-08-07 14:06
 **/

@Component
@EnableScheduling
@Slf4j
public class ProjectSecurityScoreTask {

    @Autowired
    IProjectService iProjectService;


    @Autowired
    IProjectScoreService iProjectScoreService;


    /**
     * 两小时计算一次
     */
    @Scheduled(cron = "0 0 0/2 * * ? ")
    public void securityScorek() {
        log.info("定时任务统计项目分数开始--------------->");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String day = dateFormat.format(new Date());
        String start = day + " 00:00:00";
        String end = day + " 23:59:59";
        List<Project> projects = iProjectService.list();
        if (StringUtil.isNotEmpty(projects)) {
            projects.forEach(p -> {
                try {
                    Long projectId = p.getId();
                    if (projectId != 0L) {
                        ProjectScore projectScore =
                                iProjectScoreService.getOne(new LambdaQueryWrapper<ProjectScore>().eq(ProjectScore::getProjectId, projectId).between(ProjectScore::getCreateDate, start, end));
                        if (projectScore == null) {
                            projectScore = new ProjectScore();
                            Integer score = iProjectService.securityScore(projectId);
                            projectScore.setScore(Long.valueOf(score));
                            projectScore.setProjectId(projectId);
                            projectScore.setCreateDate(new Date());
                            iProjectScoreService.save(projectScore);
                        } else {
                            Integer score = iProjectService.securityScore(projectId);
//                            if (score < projectScore.getScore()) {
                                projectScore.setScore(Long.valueOf(score));
                                projectScore.setCreateDate(new Date());
                                iProjectScoreService.updateById(projectScore);
//                            }
                        }
                    }
                } catch (Exception e) {
                    log.error("定时任务错误,工程id:{}", p.getId());
                }
            });
        }
        log.info("定时任务统计项目分数结束--------------->");
    }


}
