package com.yeejoin.precontrol.common.vo;

import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.annotations.TableFormat;
import com.yeejoin.precontrol.common.dto.FileDto;
import com.yeejoin.precontrol.common.entity.TaskPerson;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @description: 技术交底
 * @author: duanwei
 * @date: 2020-07-17 15:48
 **/
@Data
public class SingJobDisclosureVo {

    //人员类型 0主持人 1交底人 2施工负责人 3安全员 4交底人员 5记录人 6技术员 7工程人员 8施工人员 9违章人员 10分包商负责人 99 发布人
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "任务id")
    private Long id;
    @ApiModelProperty(value = "所属项目id")
    @TableFormat(entityName = "rpm_project", fieldName = "name", operFieldName = "projectName")
    private Long projectId;
    private String projectName;
    @ApiModelProperty(value = "任务编号")
    private String taskNo;
    @ApiModelProperty(value = "发起人")
    private String createPersonName;
    @ApiModelProperty(value = "任务状态名称")
    private String statusName;
    @ApiModelProperty(value = "方案名称")
    private String name;
    @ApiModelProperty(value = "方案代号")
    private String code;
    @ApiModelProperty(value = "方案编号")
    private String number;
    @ApiModelProperty(value = "技术交底文件")
    private Long documentId;
    private String documentName;
    
    @ApiModelProperty(value = "技术交底文件内容")
    private String docContent;
    @ApiModelProperty(value = "附件")
    @ImagePrefix
    private List<FileDto> attachment;


    @ImagePrefix
    private String documentPath;
    @ApiModelProperty(value = "主持人")
    @TableFormat(entityName = "rpm_person", fieldName = "name", operFieldName = "hostPersonName")
    private Long hostPersonId;
    private String hostPersonName;
    private List<TaskPerson> hostPersonObject;
    @ApiModelProperty(value = "交底人")
    @TableFormat(entityName = "rpm_person", fieldName = "name", operFieldName = "disclosurePersonName")
    private Long disclosurePersonId;
    private String disclosurePersonName;
    private List<TaskPerson> disclosurePersonObject;
    @ApiModelProperty(value = "施工负责人")
    @TableFormat(entityName = "rpm_person", fieldName = "name", operFieldName = "constructionDirectorName")
    private Long constructionDirectorId;
    private String constructionDirectorName;
    private List<TaskPerson> constructionDirectorObject;
    @ApiModelProperty(value = "安全员")
    @TableFormat(entityName = "rpm_person", fieldName = "name", operFieldName = "safetyOfficerName")
    private Long safetyOfficerId;
    private String safetyOfficerName;
    private List<TaskPerson> safetyOfficerObject;
    @ApiModelProperty(value = "记录员")
    @TableFormat(entityName = "rpm_person", fieldName = "name", operFieldName = "noteTakerName")
    private Long noteTakerId;
    private String noteTakerName;
    private List<TaskPerson> noteTakerObject;
    @ApiModelProperty(value = "交底人员")
    @TableFormat(entityName = "rpm_person", fieldName = "name", operFieldName = "participateDisclosureName")
    private Long participateDisclosureId;
    private String participateDisclosureName;
    private List<TaskPerson> participateDisclosureObject;
    @ApiModelProperty(value = "起止时间")
    private Date startTime;
    @ApiModelProperty(value = "结束时间")
    private Date endTime;
    @ApiModelProperty(value = "二维码")
    private byte[] qrCode;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    private TaskPerson taskPerson;


}

