package com.yeejoin.amos.boot.module.ccs.biz.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireFmeaStatisticsDto;
import com.yeejoin.amos.boot.module.ccs.api.entity.FireFmeaStatistics;
import com.yeejoin.amos.boot.module.ccs.api.mapper.FireFmeaStatisticsMapper;
import com.yeejoin.amos.boot.module.ccs.api.service.IFireFmeaStatisticsService;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;

/**
 * 发生率/严重度矩阵统计表服务实现类
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Service
public class FireFmeaStatisticsServiceImpl extends BaseService<FireFmeaStatisticsDto, FireFmeaStatistics, FireFmeaStatisticsMapper> implements IFireFmeaStatisticsService {
    /**
     * 分页查询
     */
    public Page<FireFmeaStatisticsDto> queryForFireFmeaStatisticsPage(Page<FireFmeaStatisticsDto> page) {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     *
     * @param stationCode 换流站编号
     */
    public List<FireFmeaStatisticsDto> queryForFireFmeaStatisticsList(String stationCode) {
        return this.queryForTopList(20, "mutiby", false, stationCode);
    }
}