package com.yeejoin.amos.boot.module.common.biz.controller;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.common.biz.service.impl.DynamicFormColumnServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.DynamicFormColumnDto;
import com.yeejoin.amos.boot.module.common.api.dto.DynamicFormInitDto;

import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;


/**
* 动态表单树形分组字段表
*
* @author system_generator
* @date 2021-07-06
*/
@RestController
@Api(tags = "动态表单树形分组字段表Api")
@RequestMapping(value = "/common/dynamic-form-column")
public class DynamicFormColumnController extends BaseController {

    @Autowired
    DynamicFormColumnServiceImpl dynamicFormColumnServiceImpl;

    /**
             * 新增动态表单树形分组字段表
    * @return
    */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增动态表单树形分组字段表", notes = "新增动态表单树形分组字段表")
	public ResponseModel<DynamicFormColumnDto> save(@RequestBody DynamicFormColumnDto model)
	{
	    model=dynamicFormColumnServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}
	/**
             * 根据sequenceNbr更新
    * @param sequenceNbr 主键
    * @return
    */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新动态表单树形分组字段表", notes = "根据sequenceNbr更新动态表单树形分组字段表")
	public ResponseModel<DynamicFormColumnDto> updateBySequenceNbrDynamicFormColumn(@RequestBody DynamicFormColumnDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(dynamicFormColumnServiceImpl.updateWithModel(model));
	}
	/**
             * 根据sequenceNbr删除
    * @param sequenceNbr 主键
    * @return
    */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除动态表单树形分组字段表", notes = "根据sequenceNbr删除动态表单树形分组字段表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(dynamicFormColumnServiceImpl.removeById(sequenceNbr));
    }
    /**
             * 根据sequenceNbr查询
    * @param sequenceNbr  主键
    * @return
    */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个动态表单树形分组字段表",  notes = "根据sequenceNbr查询单个动态表单树形分组字段表")
	public ResponseModel<DynamicFormColumnDto> seleteOne(@PathVariable Long sequenceNbr)
	{
	    return ResponseHelper.buildResponse(dynamicFormColumnServiceImpl.queryBySeq(sequenceNbr));
	}
	/**
             * 列表分页查询
    *@param current 当前页
    *@param current 每页大小
    * @return
    */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "动态表单树形分组字段表分页查询",  notes = "动态表单树形分组字段表分页查询")
	public ResponseModel<Page<DynamicFormColumnDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam(value = "size") int size)
	{
	    Page<DynamicFormColumnDto> page=new Page<DynamicFormColumnDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(dynamicFormColumnServiceImpl.queryForDynamicFormColumnPage(page));
	}
	/**
	*列表全部数据查询
	*@return
	*/
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "动态表单树形分组字段表列表全部数据查询",   notes = "动态表单树形分组字段表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<DynamicFormColumnDto>>  selectForList()
	{
	    return ResponseHelper.buildResponse(dynamicFormColumnServiceImpl.queryForDynamicFormColumnList());
	}
	
	/**
	*列表全部数据查询
	*@return
	*/
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "动态表单树形分组字段表列表全部数据查询",   notes = "动态表单树形分组字段表列表全部数据查询")
	@GetMapping(value = "/{groupCode}/list")
	public ResponseModel<List<DynamicFormInitDto>>  selectForList(@PathVariable("groupCode") String groupCode)
	{
	    return ResponseHelper.buildResponse(dynamicFormColumnServiceImpl.getFormlist(groupCode));
	}
}
