package com.yeejoin.equipmanage.controller;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.service.impl.SyncDataServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

@RestController
@Api(tags = "南瑞Api调用")
@RequestMapping(value = "/nrApi", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class NRApiInvocationController  {


    @Autowired
    private SyncDataServiceImpl syncDataService;

    @RequestMapping(value = "/getRealTimeData", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "get", value = "获取南瑞实时数据")
    public ResponseModel<JSONObject> getRealTimeData() {
        try {
            return CommonResponseUtil.success( syncDataService.getNrRealTime());
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        return CommonResponseUtil.failure();
    }


}
