package com.yeejoin.equipmanage.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.equipmanage.common.entity.EquipmentOnCar;
import com.yeejoin.equipmanage.common.entity.StockDetail;
import com.yeejoin.equipmanage.common.entity.vo.StatisticsEquipCountVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 库存明细 Mapper 接口
 *
 * @author wujiang
 * @date 2020-07-07
 */
public interface StockDetailMapper extends BaseMapper<StockDetail> {
    public List<StockDetail> findByIdInAndStatus(@Param("ids") List<Long> ids, @Param("status") Long status);

    //库存明细id查询车辆类型名称
    List<Map<String, Object>> findCategoryNameByID(@Param("id") Long id);

    List<StatisticsEquipCountVO> getStatisticsEquipCount();

    int clearWareHouse(Long id);

    boolean updateBatch(@Param("list") List<EquipmentOnCar> list, @Param("status") Long status);

    boolean updateStatus(@Param("bean") EquipmentOnCar equipmentOnCar, Long status);
}
