package com.yeejoin.equipmanage.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.equipmanage.common.entity.EquipmentStandard;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentStandardVO;
import com.yeejoin.equipmanage.mapper.EquipmentStandardMapper;
import com.yeejoin.equipmanage.service.IEquipmentStandardService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 服务实现类
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Service
public class EquipmentStandardServiceImpl extends ServiceImpl<EquipmentStandardMapper, EquipmentStandard> implements IEquipmentStandardService {
	@Autowired
	EquipmentStandardMapper equipmentStandardMapper;
	
	@Override
	public IPage<EquipmentStandardVO> findEquipmentStandardList(Page page, String orgCode, String standardKey, String equipmentId){
		return equipmentStandardMapper.findEquipmentStandardList(page,orgCode,standardKey,equipmentId);
	}
	
	@Override
	public List<Map<String,String>> getNoAddEquipmentStandardNameList(String orgCode){
		return equipmentStandardMapper.getNoAddEquipmentStandardNameList(orgCode);
	}

	@Override
	public EquipmentStandardVO findById(Long id) {
		return equipmentStandardMapper.findById(id);
	}

}
