package com.yeejoin.equipmanage.service.impl;


import com.yeejoin.equipmanage.common.utils.StringUtil;
import com.yeejoin.equipmanage.common.vo.QREquipResponse;
import com.yeejoin.equipmanage.common.vo.ScanResult;
import com.yeejoin.equipmanage.service.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Optional;


/**
 * 扫码工厂
 * @author 
 *
 */
@Component("qRCodeFactory")
public class QRCodeFactory extends AbstractQRCodeFactory {
	
	@Resource(name = "qREquipmentKnowledgeServiceImpl")
	private IQRCodeService<ScanResult<QREquipResponse>> qREquipmentKnowledgeServiceImpl;
		
	@Resource(name = "qREquipmentDefServiceImpl")
	private IQRCodeService<ScanResult<QREquipResponse>> iQRCarServiceImpl;

	@Autowired
	IStockDetailService iStockDetailService;

	@Autowired
	IScrapDetailService iScrapDetailService;

	@Autowired
	IEquipmentSpecificSerivce equipmentSpecificSerivce;

	@Override
	public IQRCodeService<ScanResult<QREquipResponse>> createScanService(final String scanStr, String type) throws IllegalArgumentException {
		Optional<String> str = Optional.ofNullable(scanStr);
		if (str.isPresent()) {
			String[] arguments = str.get().split("#");
			switch(arguments[0]) {
				//装备，灭火药剂
				case "01":
					if (StringUtil.isNotEmpty(arguments[1])) {
						String prefix = type.substring(0, type.indexOf("_"));
						if ("equipment".equals(prefix)) {
							String result = equipmentSpecificSerivce.getEquipSpeTypeByQrcode(arguments[1]);
							if (!"equipment".equals(result)) {
								throw new RuntimeException("未知的扫码信息！");
							}
						}
						if ("agent".equals(prefix)) {
							String result = equipmentSpecificSerivce.getEquipSpeTypeByQrcode(arguments[1]);
							if (!"agent".equals(result)) {
								throw new RuntimeException("未知的扫码信息！");
							}
						}
						int count = iScrapDetailService.getOneByQrcode(arguments[1]);
						if (0 < count) {
							throw new RuntimeException("此装备已报废，请重新选择！");
						}
					}
					return qREquipmentKnowledgeServiceImpl;
//				case "02":
//					return iQRShelfCellServiceImpl;
				case "03":
					//车辆
					if (StringUtil.isNotEmpty(arguments[1])) {
						int count = iScrapDetailService.getCarByQrcode(arguments[1]);
						if (0 < count) {
							throw new RuntimeException("此车辆已报废，请重新选择！");
						}
					}
					return iQRCarServiceImpl;
				default:
					throw new RuntimeException("未知的扫码类型！ " + arguments[0]);	
			}
		}
		throw new RuntimeException("未知的扫码信息！");
	}

}
