package com.yeejoin.amos.fas.business.jpush;

/**
 * JPush 推送类型
 * @author maoying
 *
 */
public enum JPushTypeEnum {
	
	ALL("广播","1"),
	TAG("标签","2" ),
	ALIAS("别名", "3");
	
	
	/**
	 * 名称，描述
	 */
	private String name;
	/**
	 * 编码
	 */
	private String code;
	
	private JPushTypeEnum(String name, String code){
		this.name = name;
		this.code = code;
	}
	
	public static JPushTypeEnum getEnum(String code) {
		JPushTypeEnum jPushTypeEnum = null;
		for(JPushTypeEnum type: JPushTypeEnum.values()) {
			if (type.getCode().equals(code)) {
				jPushTypeEnum = type;
				break;
			}
		}
		
		return jPushTypeEnum;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

}
