package com.yeejoin.amos.patrol.business.dao.mapper;

import com.yeejoin.amos.patrol.business.entity.mybatis.*;
import com.yeejoin.amos.patrol.business.param.*;
import com.yeejoin.amos.patrol.business.util.CheckDetailInputPageParam;
import com.yeejoin.amos.patrol.business.vo.CheckAnalysisVo;
import com.yeejoin.amos.patrol.business.vo.CheckInfoVo;
import com.yeejoin.amos.patrol.core.common.response.PointCheckInfoBusinessRespone;
import com.yeejoin.amos.patrol.core.common.response.PointCheckInfoRespone;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface CheckMapper extends BaseMapper {

	long countCheckInfoData(CheckInfoPageParam param);

	List<CheckInfoVo> getCheckInfo(CheckInfoPageParam param);

	long getPlanTaskCheckCount(CheckInfoPageParam param);

	List<CheckInfoVo> getPlanTaskCheckInfo(CheckInfoPageParam param);

	List<CheckInfoVo> getPlanTaskCheckInfoByIds(CheckInfoPageParam param);

	List<CheckInfoVo> getCheckInfoNew(CheckInfoPageParam param);

	@Select("<script>"
			+ "SELECT\n" +
			"            a.id,\n" +
			"            a.org_code,\n" +
			"            a.point_id pointId,\n" +
			"            a.point_name,\n" +
			"            b.is_fixed,\n" +
			"            b.point_no pointNo,\n" +
			"            a.user_id,\n" +
			"            a.user_name,\n" +
			"            a.dep_name department_name,\n" +
			"            a.dep_id departmentId,\n" +
			"            wws.name address,\n" +
			"            date_format(`a`.`check_time`, '%Y-%m-%d %H:%i:%s') AS `checkDate`,\n" +
			"            date_format(`a`.`upload_time`, '%Y-%m-%d %H:%i:%s') AS `upload_time`,\n" +
			"            (\n" +
			"                CASE\n" +
			"                    WHEN `a`.`plan_task_detail_id` = 0 OR `a`.`plan_task_detail_id` is null THEN '计划外完成'\n" +
			"                    WHEN `a`.`plan_task_detail_id` != 0 AND `a`.`is_ok` != 3 THEN '按时完成'\n" +
			"                    WHEN `a`.`is_ok` = 3 THEN '未执行'\n" +
			"                END\n" +
			"            ) AS `Finish_Status`,\n" +
			"            (\n" +
			"                CASE\n" +
			"                    WHEN `a`.`is_ok` = 1 THEN '合格'\n" +
			"                    WHEN `a`.`is_ok` = 2 THEN '不合格'\n" +
			"                    WHEN `a`.`is_ok` = 3 THEN '漏检'\n" +
			"                END\n" +
			"            ) as is_ok,\n" +
			"            a.score,\n" +
			"            a.`route_name`,\n" +
			"            (\n" +
			"                CASE\n" +
			"                    WHEN  a.check_mode = 'QR' THEN '二维码巡检'\n" +
			"                    WHEN  a.check_mode = 'MOBILE' THEN '移动点巡检'\n" +
			"                    WHEN  a.check_mode = 'NFC' THEN 'NFC巡检'\n" +
			"                    WHEN  a.check_mode = 'WEB' THEN '录入检查点巡检'\n" +
			"                    WHEN  a.check_mode = 'WEB_OUT' THEN '外来检查'\n" +
			"                    ELSE '系统自检'\n" +
			"                END\n" +
			"            ) as check_mode,\n" +
			"            a.`plan_name` AS `plan_name`,\n" +
			"            a.plan_task_id,\n" +
			"            a.plan_id,\n" +
			"            a.`route_id`,\n" +
			"            b.`catalog_id`,\n" +
			"            a.error,\n" +
			"            a.remark,\n" +
			"            b.biz_org_name AS bizOrgName\n" +
			"        FROM\n" +
			"            `p_check` `a`\n" +
			"                LEFT JOIN `p_point` `b` ON `a`.`point_id` = `b`.`id`\n" +
			"                LEFT JOIN `p_route` `d` ON `a`.`route_id` = `d`.`id`\n" +
			"                LEFT JOIN `p_plan` `e` ON `a`.`plan_id` = `e`.`id`\n" +
			"                LEFT JOIN  wl_warehouse_structure wws on wws.id = b.risk_source_id\n" +
			"        <if test=\"dangerId != null and dangerId != ''\">\n" +
			"            LEFT JOIN ( SELECT check_id, GROUP_CONCAT( latent_danger_id ) dangerIds FROM p_latent_danger_patrol GROUP BY check_id ) t ON t.check_id = a.id\n" +
			"        </if>\n" +
			"        <trim prefix=\"WHERE\" prefixOverrides=\"AND \">\n" +
			"            <if test=\"beginDate!=null and beginDate!= ''\">and a.check_time &gt;= #{beginDate} </if>\n" +
			"            <if test=\"endDate!=null and endDate!= ''\">and a.check_time &lt;= #{endDate}</if>\n" +
			"            <if test=\"userName!=null and userName!=''\">and a.user_name like concat(concat(\"%\",#{userName}),\"%\")</if>\n" +
			"            <if test=\"pointName!=null and pointName!= ''\">and b.name like concat(concat(\"%\",#{pointName}),\"%\")</if>\n" +
			"            <if test=\"pointNo!=null and pointNo!=''\">and b.point_no like concat('%',#{pointNo},'%')</if>\n" +
			"            <if test=\"isFixed!=null and isFixed!=''\">and b.is_fixed = #{isFixed}</if>\n" +
			"            <if test=\"isOK!=null and isOK!=''\">and a.is_OK = #{isOK}</if>\n" +
			"            <if test=\"planId!=null and planId!='' \">and a.plan_Id = #{planId}</if>\n" +
			"            <if test=\"planTaskId!=null and planTaskId!=''\">and a.plan_task_id = #{planTaskId}</if>\n" +
			"            <if test=\"userId!=null and userId!=''\">and find_in_set(#{userId}, a.user_id) > 0</if>\n" +
			"            <if test=\"routeId!=null and routeId!=''\">and a.route_Id = #{routeId}</if>\n" +
			"            <if test=\"catalogId!=null and catalogId!=''\">and b.Catalog_Id = #{catalogId}</if>\n" +
			"            <if test=\"orgCode!=null and orgCode!=''\">and (a.org_Code like concat (#{orgCode},\"-%\")or a.org_Code= #{orgCode})</if>\n" +
			"            <if test=\"pointId!=null and pointId!=''\">and a.point_id = #{pointId}</if>\n" +
			"            <if test=\"checkTime!=null and checkTime!=''\">and TO_DAYS(a.check_time) = TO_DAYS(#{checkTime})</if>\n" +
			"            <if test=\"departmentId!=null and departmentId!='-1'\"> and find_in_set(#{departmentId}, a.dep_id) > 0</if>\n" +
			"            <if test=\"checkType == '计划检查'\">and a.plan_task_id &gt; 0</if>\n" +
			"            <if test=\"checkType == '无计划检查'\">and a.plan_task_id &lt;= 0</if>\n" +
			"            <choose>\n" +
			"                <when test=\"finishStatus ==  0\">and (`a`.`plan_task_detail_id` = 0 OR `a`.`plan_task_detail_id` is null)</when>\n" +
			"                <when test=\"finishStatus ==  1\">and (`a`.`plan_task_detail_id` != 0 AND `a`.`is_ok` != 3)</when>\n" +
			"                <when test=\"finishStatus ==  2\">and `a`.`is_ok` = 3</when>\n" +
			"            </choose>\n" +
			"            <if test=\"dangerId != null and dangerId != ''\">\n" +
			"                and FIND_IN_SET(#{dangerId}, t.dangerIds)\n" +
			"            </if>\n" +
			"            <if test=\"bizOrgCode != null and bizOrgCode != ''\">\n" +
			"                and  a.org_code LIKE CONCAT(#{bizOrgCode},'%')\n" +
			"            </if>\n" +
			"            <if test=\"searchDay != null and searchDay != ''\">\n" +
			"                and date_format(a.check_time, '%Y-%m-%d') = curdate()\n" +
			"            </if>\n" +
			"            <if test=\"isExecute!=null and isExecute!='' and isExecute == '3'\">and a.is_OK != #{isExecute}</if>\n" +
			"        </trim>\n" +
			"        order by #{orderBy}\n" +
			"        <choose>\n" +
			"            <when test=\"pageSize==-1\"></when>\n" +
			"            <when test=\"pageSize!=-1\">limit #{offset}, #{pageSize}</when>\n" +
			"        </choose>" + "</script>")
	List<CheckInfoVo> getCheckInfoNewPro(CheckInfoPageParam param);

	long getCheckInfoCount(CheckInfoPageParam param);

	long getCheckInfoCountNew(CheckInfoPageParam param);

	List<Map> queryUnqualifiedInputItem(@Param(value="checkId") int checkId);

	List<Map> queryCheckPointInputItem(@Param(value="planTaskId") int planTaskId, @Param(value="pointId") int pointId);

	List<PointCheckDetailBo> findCheckPointInputItem(@Param(value="checkId") long checkId);

	int checkHasRecord(CheckRecordParam requestParam);

	List<Map<String, Object>> queryCheckPointImgs(@Param(value="planTaskId") int planTaskId, @Param(value="pointId") int pointId);

	/**
	 * 巡检日历饼图数据
	 * @param param
	 * @return
	 */
	Map<String,Object> pieChartData(CheckRecordParam param);

	/**
	 * 巡检日历日历数据
	 * @param param
	 * @return
	 */
	List<Map<String,Object>> calendarData(CheckRecordParam param);

	List<Map<String, Object>> queryRecordByPointId(HashMap<String, Object> req);

	Map<String, Object> queryCheckById(@Param(value="checkId") int checkId);

	List<Map<String, Object>> queryCheckInputItems(@Param(value="checkId") int checkId);

	List<Map<String, Object>> queryCheckImgs(@Param(value="checkId") int checkId);

	/**
	 * 查询所有巡检记录图片
	 * @param param
	 * @return
	 */
	List<Map<String, Object>> getCheckInfoImgsList(CheckInfoPageParam param);

	/**
	 * 根据巡检记录id获取所有图片
	 * @param ids
	 * @return
	 */
	List<Map<String, Object>> getCheckInfoImgsByCheckIdsList(@Param(value="checkIds") Long[] ids);

	/**
	 * 根据ids获取巡检记录
	 * @param ids
	 * @return
	 */
	List<CheckInfoVo> getSelectedCheckInfoList(@Param(value="checkIds") Long[] ids);

	/**
	 * 月巡检情况统计
	 * @param param
	 * @return
	 */
	List<HashMap<String, Object>> getCountMonthChk(HashMap<String, Object> param);

	/**
	 * 月巡检情况统计
	 * @return
	 */
	List<HashMap<String, Object>> getCountMonthChkNew();
	List<HashMap<String, Object>> getCountMonthChkNewXIN(String orgCode);

	/**
	 * 获取巡检日历信息列表
	 *
	 * @param paramMap
	 * @return
	 */
	List<HashMap<String, String>> getCalenderCountInfoList(HashMap<String, Object> paramMap);

	/**
	 * 获取巡检人员
	 *
	 * @param paramsMap
	 * @return
	 */
	List<CheckUserBo> getCheckUserInfoList(HashMap<String, Object> paramsMap);

	/**
	 * 根据巡检点id获取最新一条巡检记录
	 *
	 * @param pointId
	 * @return
	 */
	Long getLastsetCheckByPointID(@Param(value = "pointID") Long pointId);

	/**
	 * 根据巡检记录ID查询巡检项个数
	 *
	 * @param checkID
	 * @return
	 */
	long countCheckInputByMybatis(@Param(value = "checkID") Long checkID);



	/**
	 * 根据巡检记录ID查询装备个数
	 *
	 * @param checkID
	 * @return
	 */
	long countClassifyByMybatis(@Param(value = "checkID") Long checkID);

	/**
	 * 根据巡检记录ID获取巡检项
	 *
	 * @param param
	 * @return
	 */
	List<CheckInputBo> getCheckInputByCheckId(CheckDetailInputPageParam param);

	/**
	 * 根据巡检记录ID获取巡检项
	 *
	 * @param param
	 * @return
	 */
	List<HashMap<String,Object>> getEquipInputByCheckId(CheckDetailInputPageParam param);

	/**
	 * 根据巡检记录ID查询巡检装备
	 *
	 * @param checkID
	 * @return
	 */
	List<HashMap<String,Object>> getCheckEquipByCheckID(Long checkID);
	/**
	 * 根据巡检记录ID获取图片信息
	 *
	 * @param param
	 * @return
	 */
	List<HashMap<String,Object>> getEquipInfoImgsByCheckIdsList(Long checkID);
	/**
	 * 根据巡检记录ID和点ID获取巡检记录详情
	 *
	 * @param param
	 * @return
	 */
	CheckDetailBo getCheckDetailByID(CheckDetailInputPageParam param);

	/**
	 * 根据巡检记录ID获取巡检记录图片信息
	 *
	 * @param checkID
	 * @return
	 */
	List<String> getCheckInputPhotoByID(@Param(value = "checkId") Long checkID);

	/**
	 * 查询巡检轨迹数量
	 *
	 * @param params
	 * @return
	 */
	long countCheckTraListData(CheckPtListPageParam params);

	/**
	 * 查询巡检轨迹
	 *
	 * @param params
	 * @return
	 */
	List<CheckTraListBo> getCheckTraList(CheckPtListPageParam params);

	/**
	 * 根据检查id获取检查信息
	 * @param checkId
	 * @return
	 */
	List<PointCheckInfoRespone> getCheckInfoById(@Param(value = "checkId") Long checkId);

    /**
     * 计划路线点最新巡检记录查询
     * @param params
     * @return
     */
	List<PlanRoutePointBo> getLastPointCheckList(CheckPtListPageParam params);

	/**
	 * 计划路线点最新巡检记录分页统计用
	 * @param params
	 * @return
	 */
	long countLastPointCheckData(CheckPtListPageParam params);

	/**
	 * 查询巡检记录信息记录个数
	 *
	 * @param params
	 * @return
	 */
	long countCheckInfoListData(CheckInfoListPageParam params);
	long countCheckInfoListData1(CheckInfoListPageParam params);

	/**
	 * 查询巡检记录列表信息
	 *
	 * @param params
	 * @return
	 */
	List<CheckInfoBo> getCheckInfoList(CheckInfoListPageParam params);

	List<Map<String,Object>> getCheckInfoList1(CheckInfoListPageParam params);
	/**
	 * 查询点及线路信息
	 * @return
	 */
	public List<Map<String,Object>> getRoutesAndPointsInfo();

	/**
	 * 巡检情况统计分析
	 * @param param
	 * @return
	 */
	List<CheckAnalysisVo> getCheckStatisticalAnalysis(CheckStatisticalParam param);

	/**
	 * 根据orgCode查询公司累计巡检次数
	 * @param loginOrgCode
	 * @return
	 */
	long getCumulativeCheckCountByOrgCode(String loginOrgCode);

	/**
	 * 根据条件查询日巡检次数
	 * @param param
	 * @return
	 */
	List<Long> getCheckDataCount(HashMap<String, Object> param);

	PointCheckInfoBusinessRespone getCheckInfoBusinessById(@Param(value = "checkId") Long checkId);

	List<String> getLivePhotos(@Param(value = "checkId") Long checkID);


	List<String> getPhotosByCheckIDAndInputId(@Param(value = "checkId") int checkId, @Param(value = "checkInputId")int checkInputId, @Param(value = "classifyId")int classifyId);

    List<Long> getPlanCheckDataCount(HashMap<String, Object> param);

    //Map<String, String> queryUserInfoByIds(@Param(value = "userIds") String userIds);

	Integer delCheckByTaskId(@Param(value = "taskId") Long taskId, @Param(value = "pointId") Long pointId);

	Integer delCheckInputByCheckId(@Param(value = "ids")  List<Long> ids);

	List<Map<String, Object>> selectCheckById(@Param(value = "taskId") Long taskId, @Param(value = "pointId") Long pointId);

	List<Map<String, Object>> queryCheckInputItemsByCheckId(@Param(value="checkId") long checkId);

	Map<String, Object> getPeopleStatistic(@Param(value = "bizOrgCode") String bizOrgCode, @Param(value = "userId") String userId);

	long getPeoplePageCount(CheckInfoPageParam param);

	List<CheckInfoVo> getPeopleCheckPage(CheckInfoPageParam param);

	@Select("<script>"
			+ "SELECT\n" +
			"        a.id,\n" +
			"        a.user_id,\n" +
			"        date_format(\n" +
			"        `a`.`check_time`,\n" +
			"        '%Y-%m-%d %H:%i:%s'\n" +
			"        ) AS `checkTime`,\n" +
			"        (\n" +
			"        CASE\n" +
			"        WHEN `a`.`is_ok` = 1\n" +
			"        THEN '合格'\n" +
			"        WHEN `a`.`is_ok` = 2\n" +
			"        THEN '不合格'\n" +
			"        WHEN `a`.`is_ok` = 3\n" +
			"        THEN '漏检'\n" +
			"        END\n" +
			"        ) as is_ok\n" +
			"        FROM\n" +
			"        `p_check` `a`\n" +
			"        <trim prefix=\"WHERE\" prefixOverrides=\"AND \">\n" +
			"            `a`.`is_ok` != 1\n" +
			"            <if test=\"userId!=null and userId!=''\">and a.user_id = #{userId}</if>\n" +
			"            <if test=\"bizOrgCode != null and bizOrgCode != ''\">\n" +
			"                and a.org_code LIKE CONCAT(#{bizOrgCode},'%')\n" +
			"            </if>\n" +
			"        </trim>\n" +
			"        order by #{orderBy}\n" +
			"        <choose>\n" +
			"            <when test=\"pageSize==-1\"></when>\n" +
			"            <when test=\"pageSize!=-1\">limit #{offset},#{pageSize}</when>\n" +
			"        </choose>" + "</script>")
	List<CheckInfoVo> getPeopleCheckPageNew(CheckInfoPageParam param);
}
